/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.util;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;

public abstract class UUIDFetcher {
    public static final Pattern CLASSIC_GAMERTAG_PATTERN = Pattern.compile("^[a-zA-Z0-9 ]{1,15}$");
    protected static UUIDFetcher instance;

    public abstract CompletableFuture<String> getName(UUID var1);

    public abstract CompletableFuture<String> getName(long var1);

    public abstract CompletableFuture<UUID> getUUID(String var1);

    public abstract CompletableFuture<UUID> getOnlineUUID(String var1);

    public abstract UUID getOnlineUUID(long var1);

    public abstract UUID getOfflineUUID(String var1);

    public abstract CompletableFuture<Long> getXUID(String var1);

    public abstract long getXUID(UUID var1);

    public abstract CompletableFuture<String> getSkinTextureURL(String var1);

    public abstract CompletableFuture<String> getSkinTextureURL(UUID var1);

    public abstract CompletableFuture<String> getSkinTextureURL(long var1);

    public static UUIDFetcher getInstance() {
        return instance;
    }

    public static UUID dash(String nonDashedUUID) {
        if (nonDashedUUID.length() == 32) {
            return new UUID(Long.parseUnsignedLong(nonDashedUUID.substring(0, 16), 16), Long.parseUnsignedLong(nonDashedUUID.substring(16), 16));
        }
        throw new IllegalArgumentException("Specified non-dashed UUID is not 32 characters long");
    }

    public static boolean isValidClassicGamertag(String classicGamertag) {
        return CLASSIC_GAMERTAG_PATTERN.matcher(classicGamertag).matches();
    }
}

