/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.util;

import me.remigio07.chatplugin.api.common.storage.configuration.ConfigurationType;
import me.remigio07.chatplugin.api.common.util.Utils;

public enum MemoryUtils {
    TEBIBYTE(0, "TiB"),
    TERABYTE(-727379968, "TB"),
    GIBIBYTE(0x40000000, "GiB"),
    GIGABYTE(1000000000, "GB"),
    MEBIBYTE(0x100000, "MiB"),
    MEGABYTE(1000000, "MB"),
    KIBIBYTE(1024, "KiB"),
    KILOBYTE(1000, "KB"),
    BYTE(1, "B");

    private int toBytesRatio;
    private String unit;

    private MemoryUtils(int toBytesRatio, String unit) {
        this.toBytesRatio = toBytesRatio;
        this.unit = unit;
    }

    public int getToBytesRatio() {
        return this.toBytesRatio;
    }

    public String getUnit() {
        return this.unit;
    }

    public static MemoryUtils getDisplayedUnit() {
        return MemoryUtils.valueOf(ConfigurationType.CONFIG.get().getString("settings.displayed-memory.unit", "MEGABYTE"));
    }

    public static String formatMemory(long bytes) {
        int decimals = ConfigurationType.CONFIG.get().getInt("settings.displayed-memory.decimals");
        double adjusted = (double)bytes / (double)MemoryUtils.getDisplayedUnit().getToBytesRatio();
        return decimals == 0 ? String.valueOf((long)adjusted) : String.valueOf(Utils.truncate(adjusted, decimals));
    }

    public static String formatMemory(long bytes, MemoryUtils scale) {
        double adjusted = (double)bytes / (double)scale.getToBytesRatio();
        return Double.valueOf(Utils.truncate(adjusted, 2)) / (double)((long)adjusted) == 1.0 ? String.valueOf((long)adjusted) : String.valueOf(Utils.truncate(adjusted, 2));
    }
}

