/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.util;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.remigio07.chatplugin.api.common.discord.DiscordIntegrationManager;
import me.remigio07.chatplugin.api.common.ip_lookup.LocalIPLookupManager;
import me.remigio07.chatplugin.api.common.telegram.TelegramIntegrationManager;

public enum Library {
    ACTIVATION_FRAMEWORK("Activation Framework", "javax.activation.DataSource", new Relocation("com.sun.activation", "javax.activation"), "https://repo1.maven.org/maven2/com/sun/activation/javax.activation/1.2.0/javax.activation-1.2.0.jar", "activation-framework.jar", "BE7C430DF50B330CFFC4848A3ABEDBFB"),
    APACHE_COMMONS_CODEC("Apache Commons Codec", "org.apache.commons.codec.Charsets", new Relocation("org.apache.commons.codec"), "https://repo1.maven.org/maven2/commons-codec/commons-codec/1.15/commons-codec-1.15.jar", "apache-commons-codec.jar", "303BAF002CE6D382198090AEDD9D79A2"),
    APACHE_COMMONS_COLLECTIONS("Apache Commons Collections", "org.apache.commons.collections4.Trie", new Relocation("org.apache.commons.collections4"), "https://repo1.maven.org/maven2/org/apache/commons/commons-collections4/4.4/commons-collections4-4.4.jar", "apache-commons-collections.jar", "4A37023740719B391F10030362C86BE6"),
    APACHE_COMMONS_LOGGING("Apache Commons Logging", "org.apache.commons.logging.Log", new Relocation("org.apache.commons.logging"), "https://repo1.maven.org/maven2/commons-logging/commons-logging/1.2/commons-logging-1.2.jar", "apache-commons-logging.jar", "040B4B4D8EAC886F6B4A2A3BD2F31B00"),
    APACHE_COMMONS_MATH("Apache Commons Math", "org.apache.commons.math3.Field", new Relocation("assets.org.apache.commons.math3", "org.apache.commons.math3"), "https://repo1.maven.org/maven2/org/apache/commons/commons-math3/3.6.1/commons-math3-3.6.1.jar", "apache-commons-math.jar", "5B730D97E4E6368069DE1983937C508E"),
    APACHE_HTTPCLIENT("Apache HttpClient", "org.apache.http.auth.Credentials", new Relocation("mozilla", "org.apache.http"), "https://repo1.maven.org/maven2/org/apache/httpcomponents/httpclient/4.5.14/httpclient-4.5.14.jar", "apache-httpclient.jar", "2CB357C4B763F47E58AF6CAD47DF6BA3"),
    APACHE_HTTPCORE("Apache HttpCore", "org.apache.http.HttpHost", new Relocation("org.apache.http"), "https://repo1.maven.org/maven2/org/apache/httpcomponents/httpcore/4.4.16/httpcore-4.4.16.jar", "apache-httpcore.jar", "28D2CD9BF8789FD2EC774FB88436EBD1"),
    ASM("ASM", "org.objectweb.asm.ModuleVisitor", "https://repo1.maven.org/maven2/org/ow2/asm/asm/7.2/asm-7.2.jar", "asm.jar", "26CF10DFD4729FD22FCAE0694E041167"),
    ASM_COMMONS("ASM Commons", "org.objectweb.asm.commons.ClassRemapper", "https://repo1.maven.org/maven2/org/ow2/asm/asm-commons/7.2/asm-commons-7.2.jar", "asm-commons.jar", "321121317A6C6221CC26E8F9EE97022F"),
    BUNGEECORD_CHAT("BungeeCord Chat", "net.md_5.bungee.api.ChatColor", "https://repo1.maven.org/maven2/net/md-5/bungeecord-chat/1.21-R0.4/bungeecord-chat-1.21-R0.4.jar", "bungeecord-chat.jar", "2E79C81EE7404D526F13ED74715A40FD"),
    BUNGEECORD_DIALOG("BungeeCord Dialog", "net.md_5.bungee.api.dialog.Dialog", "https://repo1.maven.org/maven2/net/md-5/bungeecord-dialog/1.21-R0.4/bungeecord-dialog-1.21-R0.4.jar", "bungeecord-dialog.jar", "08C7C156E79793BFCE6A1D92A7B86FD0"),
    BUNGEECORD_SERIALIZER("BungeeCord Serializer", "net.md_5.bungee.api.ChatColor", "https://repo1.maven.org/maven2/net/md-5/bungeecord-serializer/1.21-R0.4/bungeecord-serializer-1.21-R0.4.jar", "bungeecord-serializer.jar", "BB87006A2F281FC520CEC566DE14742D"),
    CHECKER_QUAL("Checker Qual", "org.checkerframework.dataflow.qual.Deterministic", new Relocation("org.checkerframework"), "https://repo1.maven.org/maven2/org/checkerframework/checker-qual/3.21.0/checker-qual-3.21.0.jar", "checker-qual.jar", "275841B506F4B14EAF4E7892329DD26F"),
    ERROR_PRONE_ANNOTATIONS("Error Prone Annotations", "com.google.errorprone.annotations.Var", new Relocation("com.google.errorprone.annotations"), "https://repo1.maven.org/maven2/com/google/errorprone/error_prone_annotations/2.10.0/error_prone_annotations-2.10.0.jar", "error-prone-annotations.jar", "DF93BD9F00B1D2B1E2CA6317FD8F6DF3"),
    FAILURE_ACCESS("Failure Access", "com.google.common.util.concurrent.internal.InternalFutureFailureAccess", new Relocation("com.google.common.util.concurrent.internal"), "https://repo1.maven.org/maven2/com/google/guava/failureaccess/1.0.1/failureaccess-1.0.1.jar", "failure-access.jar", "091883993EF5BFA91DA01DCC8FC52236"),
    FINDBUGS_JSR305("FindBugs JSR305", "javax.annotation.Nullable", new Relocation("javax.annotation"), "https://repo1.maven.org/maven2/com/google/code/findbugs/jsr305/3.0.2/jsr305-3.0.2.jar", "findbugs-jsr305.jar", "DD83ACCB899363C32B07D7A1B2E4CE40"),
    GNU_TROVE("GNU Trove", "gnu.trove.Version", new Relocation("gnu.trove"), "https://repo1.maven.org/maven2/net/sf/trove4j/core/3.1.0/core-3.1.0.jar", "gnu-trove.jar", "DB61170EB992D933F4119172326DF9B6"),
    GSON("Gson", "com.google.gson.ToNumberPolicy", "https://repo1.maven.org/maven2/com/google/code/gson/gson/2.13.2/gson-2.13.2.jar", "gson.jar", "A2C47E14CE5E956105458FE455F5D542"),
    GUAVA("Guava", "com.google.common.annotations.GwtCompatible", new Relocation("com.google"), "https://repo1.maven.org/maven2/com/google/guava/guava/31.0.1-jre/guava-31.0.1-jre.jar", "guava.jar", "BB811CA86CBA6506CCA5D415CD5559A7"),
    H2_DATABASE_ENGINE("H2 Database Engine", "org.h2.Driver", "https://repo1.maven.org/maven2/com/h2database/h2/2.2.224/h2-2.2.224.jar", "h2-driver.jar", "769D5A85D19CCC2B06620F8C81D6D8F8"),
    ICE_TAR("Ice TAR", "com.ice.tar.TarProgressDisplay", new Relocation("com.ice.tar"), "https://repo1.maven.org/maven2/javatar/javatar/2.5/javatar-2.5.jar", "ice-tar.jar", "3E0E11B872EEE1822ED3C0690380D22A"),
    J2OBJC_ANNOTATIONS("J2ObjC Annotations", "com.google.j2objc.annotations.Weak", new Relocation("com.google.j2objc.annotations"), "https://repo1.maven.org/maven2/com/google/j2objc/j2objc-annotations/1.3/j2objc-annotations-1.3.jar", "j2objc-annotations.jar", "5FA4EC4EC0C5AA70AF8A7D4922DF1931"),
    JACKSON_ANNOTATIONS("Jackson Annotations", "com.fasterxml.jackson.annotation.JacksonAnnotation", new Relocation("com.fasterxml.jackson.annotation"), "https://repo1.maven.org/maven2/com/fasterxml/jackson/core/jackson-annotations/2.16.0/jackson-annotations-2.16.0.jar", "jackson-annotations.jar", "9CAEC6E7CDD5CC18E18F99359B9E8D95"),
    JACKSON_CORE("Jackson Core", "com.fasterxml.jackson.core.Versioned", new Relocation("com.fasterxml.jackson.core"), "https://repo1.maven.org/maven2/com/fasterxml/jackson/core/jackson-core/2.16.0/jackson-core-2.16.0.jar", "jackson-core.jar", "E2510FA60B7D363566A9016A8C40710F"),
    JACKSON_DATABIND("Jackson Databind", "com.fasterxml.jackson.databind.annotation.NoClass", new Relocation("com.fasterxml.jackson.databind"), "https://repo1.maven.org/maven2/com/fasterxml/jackson/core/jackson-databind/2.16.0/jackson-databind-2.16.0.jar", "jackson-databind.jar", "F9AE3E3BD773BE8B474CB1B98DCF7EE6"),
    JAR_RELOCATOR("JAR Relocator", "me.remigio07.jarrelocator.JarRelocator", "https://github.com/Remigio07/JAR-Relocator/releases/download/v1.6/JAR-Relocator-1.6.jar", "jar-relocator.jar", "673F248643DD9B3FBEDBC1FE01FD6F04"),
    JAVA_NATIVE_ACCESS("Java Native Access", "com.sun.jna.Version", new Relocation("com.sun.jna"), "https://repo1.maven.org/maven2/net/java/dev/jna/jna/5.10.0/jna-5.10.0.jar", "java-native-access.jar", "2B884B01AD2F62D4F5DD11387A8BF799"),
    JAVA_TELEGRAM_BOT_API("Java Telegram Bot API", "com.pengrad.telegrambot.TelegramBot", new Relocation("com.pengrad.telegrambot"), "https://repo1.maven.org/maven2/com/github/pengrad/java-telegram-bot-api/7.9.1/java-telegram-bot-api-7.9.1.jar", "java-telegram-bot-api.jar", "A986C13BB1095CA698F46AB1B60583C7"),
    JAVAX_ANNOTATION("Javax Annotation", "javax.annotation.Priority", new Relocation("javax.annotation"), "https://repo1.maven.org/maven2/javax/annotation/javax.annotation-api/1.3.2/javax.annotation-api-1.3.2.jar", "javax-annotation.jar", "2AB1973EEFFFAA2AEEC47D50B9E40B9D"),
    JDA("JDA", "net.dv8tion.jda.api.JDA", new Relocation("net.dv8tion.jda"), "https://repo1.maven.org/maven2/net/dv8tion/JDA/5.1.0/JDA-5.1.0.jar", "jda.jar", "E211D9DA4E6A68233AA97679693B8F79"),
    JETBRAINS_ANNOTATIONS("Jetbrains Annotations", "org.jetbrains.annotations.Nullable", new Relocation("org.intellij.lang.annotations", "org.jetbrains.annotations"), "https://repo1.maven.org/maven2/org/jetbrains/annotations/24.1.0/annotations-24.1.0.jar", "jetbrains-annotations.jar", "38673ABE87D12508CD05498EFF0B9731"),
    JSON_SIMPLE("JSON.simple", "com.github.cliftonlabs.json_simple.Jsonable", new Relocation("com.github.cliftonlabs.json_simple"), "https://repo1.maven.org/maven2/com/github/cliftonlabs/json-simple/4.0.0/json-simple-4.0.0.jar", "json-simple.jar", "8859BDA915254B3FA55ABBC17C21E67C"),
    KOTLIN_STDLIB("Kotlin Stdlib", "kotlin.Deprecated", new Relocation(new String[0]), "https://repo1.maven.org/maven2/org/jetbrains/kotlin/kotlin-stdlib/1.8.21/kotlin-stdlib-1.8.21.jar", "kotlin-stdlib.jar", "E4424CF44B4F8F7CD1517EAFDDA2F6A7"),
    LOGGING_INTERCEPTOR("Logging Interceptor", "okhttp.logging.HttpLoggingInterceptor", new Relocation("okhttp.logging"), "https://repo1.maven.org/maven2/com/squareup/okhttp3/logging-interceptor/4.12.0/logging-interceptor-4.12.0.jar", "logging-interceptor.jar", "48029BA5A920BBB533503169CBA8E498"),
    MAXMIND_DB_READER("MaxMind DB Reader", "com.maxmind.db.NodeCache", new Relocation("com.maxmind.db"), "https://repo1.maven.org/maven2/com/maxmind/db/maxmind-db/2.1.0/maxmind-db-2.1.0.jar", "maxmind-db-reader.jar", "E365D939445EF5AB91669A1C175D4E66"),
    MAXMIND_GEOIP2("MaxMind GeoIP2", "com.maxmind.geoip2.GeoIp2Provider", new Relocation("com.maxmind.geoip2"), "https://repo1.maven.org/maven2/com/maxmind/geoip2/geoip2/2.17.0/geoip2-2.17.0.jar", "maxmind-geoip2.jar", "4FD0A1FFF425A2C387D58D1DBB3E5FDD"),
    MYSQL_CONNECTOR_J("MySQL Connector/J", "com.mysql.jdbc.Driver", new Relocation("com.mysql"), "https://repo1.maven.org/maven2/com/mysql/mysql-connector-j/9.1.0/mysql-connector-j-9.1.0.jar", "mysql-connector-j.jar", "DB2BDCFD7C2184780B5CDA29D8AF6997"),
    NV_WEBSOCKET_CLIENT("NV WebSocket Client", "com.neovisionaries.ws.client.Connectable", new Relocation("com.neovisionaries.ws.client"), "https://repo1.maven.org/maven2/com/neovisionaries/nv-websocket-client/2.14/nv-websocket-client-2.14.jar", "nv-websocket-client.jar", "27CF8D475BF9DCF035E0966810BDDED2"),
    OKHTTP("OkHttp", "okhttp3.Call", new Relocation("okhttp3"), "https://repo1.maven.org/maven2/com/squareup/okhttp3/okhttp/4.12.0/okhttp-4.12.0.jar", "okhttp.jar", "6ACBA053AF88FED87E710C6C29911D7C"),
    OKIO("Okio", "okio.Source", new Relocation("okio"), "https://repo1.maven.org/maven2/com/squareup/okio/okio-jvm/3.6.0/okio-jvm-3.6.0.jar", "okio.jar", "26370180FF99A7E8A12DCAAC2A70CC6E"),
    SLF4J_API("SLF4J API", "org.slf4j.IMarkerFactory", new Relocation("org.slf4j"), "https://repo1.maven.org/maven2/org/slf4j/slf4j-api/1.7.36/slf4j-api-1.7.36.jar", "slf4j-api.jar", "872DA51F5DE7F3923DA4DE871D57FD85"),
    SLF4J_SIMPLE_PROVIDER("SLF4J Simple Provider", "org.slf4j.impl.SimpleLogger", new Relocation("org.slf4j.impl"), "https://repo1.maven.org/maven2/org/slf4j/slf4j-simple/1.7.36/slf4j-simple-1.7.36.jar", "slf4j-simple-provider.jar", "FD4A5FA54910B5EE561F639C903CF34A"),
    SNAKEYAML("SnakeYAML", "org.snakeyaml.yaml.Yaml", "https://repo1.maven.org/maven2/org/yaml/snakeyaml/2.5/snakeyaml-2.5.jar", "snakeyaml.jar", "8D3B7581DB5C7620DB55183F33A4F2AD"),
    SQLITE_JDBC("SQLite JDBC", "org.sqlite.JDBC", "https://repo1.maven.org/maven2/org/xerial/sqlite-jdbc/3.47.0.0/sqlite-jdbc-3.47.0.0.jar", "sqlite-driver.jar", "07B66539A5703FA7DEF2D8BBCBC51070");

    private String name;
    private String clazz;
    private String url;
    private String fileName;
    private String md5Hash;
    private Relocation relocation;

    private Library(String name, String clazz, String url, String fileName, String md5Hash) {
        this(name, clazz, null, url, fileName, md5Hash);
    }

    private Library(String name, String clazz, Relocation relocation, String url, String fileName, String md5Hash) {
        this.name = name;
        this.clazz = (relocation == null ? "" : "me.remigio07.chatplugin.common.lib.") + clazz;
        this.relocation = relocation;
        this.url = url;
        this.fileName = fileName;
        this.md5Hash = md5Hash;
    }

    public String getName() {
        return this.name;
    }

    public String getClazz() {
        return this.clazz;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getMD5Hash() {
        return this.md5Hash;
    }

    public Relocation getRelocation() {
        return this.relocation;
    }

    public URL getURL() {
        try {
            return new URI(this.url).toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        Library.JACKSON_DATABIND.getRelocation().add(new Library[]{Library.JACKSON_CORE, Library.JACKSON_ANNOTATIONS});
        Library.APACHE_HTTPCLIENT.getRelocation().add(new Library[]{Library.APACHE_COMMONS_CODEC, Library.APACHE_COMMONS_LOGGING, Library.APACHE_HTTPCORE});
        Library.GUAVA.getRelocation().add(new Library[]{Library.FINDBUGS_JSR305, Library.ERROR_PRONE_ANNOTATIONS, Library.FAILURE_ACCESS, Library.J2OBJC_ANNOTATIONS, Library.CHECKER_QUAL});
        Library.JDA.getRelocation().add(DiscordIntegrationManager.LIBRARIES);
        Library.KOTLIN_STDLIB.getRelocation().add(new Library[]{Library.JETBRAINS_ANNOTATIONS});
        Library.MAXMIND_GEOIP2.getRelocation().add(LocalIPLookupManager.LIBRARIES);
        Library.SLF4J_SIMPLE_PROVIDER.getRelocation().add(new Library[]{Library.SLF4J_API});
        Library.OKHTTP.getRelocation().add(new Library[]{Library.JETBRAINS_ANNOTATIONS});
        Library.OKIO.getRelocation().add(new Library[]{Library.KOTLIN_STDLIB});
        Library.OKHTTP.getRelocation().add(new Library[]{Library.OKIO});
        Library.LOGGING_INTERCEPTOR.getRelocation().add(new Library[]{Library.OKHTTP});
        Library.JAVA_TELEGRAM_BOT_API.getRelocation().add(TelegramIntegrationManager.LIBRARIES);
    }

    public static class Relocation {
        public static final String PREFIX = "me.remigio07.chatplugin.common.lib.";
        private List<String> oldPackages;

        public Relocation(String ... oldPackages) {
            this.oldPackages = new ArrayList<String>(Arrays.asList(oldPackages));
        }

        public List<String> getOldPackages() {
            return this.oldPackages;
        }

        private Relocation add(Library ... libraries) {
            for (Library library : libraries) {
                if (library.getRelocation() == null || this.oldPackages.containsAll(library.getRelocation().getOldPackages())) continue;
                this.oldPackages.addAll(library.getRelocation().getOldPackages());
            }
            return this;
        }
    }
}

