/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.storage.database;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import me.remigio07.chatplugin.api.common.storage.DataContainer;
import me.remigio07.chatplugin.api.common.storage.StorageManager;
import me.remigio07.chatplugin.api.common.storage.configuration.ConfigurationType;
import me.remigio07.chatplugin.api.common.storage.database.DatabaseConnector;

public abstract class DatabaseManager
extends StorageManager {
    @Override
    public DatabaseConnector getConnector() {
        return (DatabaseConnector)this.connector;
    }

    protected void ensureCompatibility() throws SQLException {
        try (PreparedStatement statement = this.getConnector().getConnection().prepareStatement("SHOW COLUMNS FROM " + DataContainer.PUBLIC_MESSAGES.getDatabaseTableID());){
            statement.execute();
            try (ResultSet result = statement.getResultSet();){
                String columnName = null;
                while (result.next()) {
                    columnName = result.getString("FIELD");
                }
                if ("global".equalsIgnoreCase(columnName)) {
                    this.getConnector().executeUpdate("ALTER TABLE " + DataContainer.PRIVATE_MESSAGES.getDatabaseTableID() + " MODIFY COLUMN `rank_id` VARCHAR(36) NOT NULL", new Object[0]);
                    this.getConnector().executeUpdate("ALTER TABLE " + DataContainer.PUBLIC_MESSAGES.getDatabaseTableID() + " MODIFY COLUMN `rank_id` VARCHAR(36) NOT NULL", new Object[0]);
                    this.getConnector().executeUpdate("ALTER TABLE " + DataContainer.PUBLIC_MESSAGES.getDatabaseTableID() + " ADD `channel_id` VARCHAR(36) AFTER `world`", new Object[0]);
                    this.getConnector().executeUpdate("ALTER TABLE " + DataContainer.PUBLIC_MESSAGES.getDatabaseTableID() + " DROP COLUMN `global`", new Object[0]);
                }
            }
        }
    }

    public static DatabaseManager getInstance() {
        return (DatabaseManager)instance;
    }

    public static String getTablePrefix() {
        return ConfigurationType.CONFIG.get().getString("storage.database.table-prefix");
    }
}

