/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.storage.database;

import java.io.IOException;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import me.remigio07.chatplugin.api.ChatPlugin;
import me.remigio07.chatplugin.api.common.player.OfflinePlayer;
import me.remigio07.chatplugin.api.common.storage.DataContainer;
import me.remigio07.chatplugin.api.common.storage.PlayersDataType;
import me.remigio07.chatplugin.api.common.storage.StorageConnector;
import me.remigio07.chatplugin.api.common.storage.StorageManager;
import me.remigio07.chatplugin.api.common.util.VersionUtils;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManagerException;
import me.remigio07.chatplugin.api.common.util.manager.LogManager;
import me.remigio07.chatplugin.api.common.util.manager.TaskManager;
import me.remigio07.chatplugin.bootstrap.Environment;
import org.bukkit.Statistic;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.statistic.Statistics;

public abstract class DatabaseConnector
extends StorageConnector {
    protected Connection connection;

    @Override
    public void unload() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
        this.connection = null;
    }

    @Override
    public <T> T select(DataContainer container, String position, Class<T> type, StorageConnector.WhereCondition ... conditions) throws SQLException {
        return this.get("SELECT " + position + " FROM " + container.getDatabaseTableID() + this.combineWhereConditions(conditions), position, type, this.combineSecondTermValues(conditions));
    }

    @Override
    public Number count(DataContainer container, StorageConnector.WhereCondition ... conditions) throws SQLException {
        return this.get("SELECT COUNT(*) FROM " + container.getDatabaseTableID() + this.combineWhereConditions(conditions), 1, Number.class, this.combineSecondTermValues(conditions));
    }

    @Override
    public int update(DataContainer container, String position, Object data, StorageConnector.WhereCondition ... conditions) throws SQLException {
        Object[] args = Arrays.copyOf(new Object[]{data}, conditions.length + 1);
        System.arraycopy(this.combineSecondTermValues(conditions), 0, args, 1, conditions.length);
        return this.executeUpdate("UPDATE " + container.getDatabaseTableID() + " SET " + position + " = ?" + this.combineWhereConditions(conditions), args);
    }

    @Override
    public int delete(DataContainer container, StorageConnector.WhereCondition ... conditions) throws SQLException {
        return this.executeUpdate("DELETE FROM " + container.getDatabaseTableID() + this.combineWhereConditions(conditions), this.combineSecondTermValues(conditions));
    }

    @Override
    public <T> List<T> getColumnValues(DataContainer container, String position, Class<T> type, StorageConnector.WhereCondition ... conditions) throws SQLException {
        return this.getColumnValues("SELECT " + position + " FROM " + container.getDatabaseTableID() + this.combineWhereConditions(conditions), position, type, this.combineSecondTermValues(conditions));
    }

    private String combineWhereConditions(StorageConnector.WhereCondition ... conditions) {
        if (conditions.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(" WHERE ");
        for (StorageConnector.WhereCondition condition : conditions) {
            sb.append(condition.getFirstTermPosition() + " " + condition.getOperator().toString() + " ? AND ");
        }
        sb.delete(sb.length() - 5, sb.length());
        return sb.toString();
    }

    private Object[] combineSecondTermValues(StorageConnector.WhereCondition ... conditions) {
        Object[] values = new Object[conditions.length];
        for (int i = 0; i < conditions.length; ++i) {
            values[i] = conditions[i].getSecondTermValue();
        }
        return values;
    }

    @Override
    public List<Object> getRowValues(DataContainer table, int id) throws SQLException {
        if (table == DataContainer.PUBLIC_MESSAGES || table == DataContainer.PRIVATE_MESSAGES) {
            throw new IllegalArgumentException("Unable to get row values in table " + table.getDatabaseTableID() + " using an ID since that table does not have IDs");
        }
        ArrayList<Object> list = new ArrayList<Object>();
        try (PreparedStatement statement = this.prepareStatement("SELECT * FROM " + table.getDatabaseTableID() + " WHERE " + table.getIDColumn() + " = ?", id);){
            statement.execute();
            ResultSet result = statement.getResultSet();
            if (!result.next()) {
                List<Object> list2 = null;
                return list2;
            }
            for (int i = 1; i < table.getColumns().length + 1; ++i) {
                list.add(result.getObject(i));
            }
            statement.clearParameters();
        }
        return list;
    }

    @Override
    public void setData(DataContainer table, String column, int id, Object data) throws SQLException {
        if (table == DataContainer.PUBLIC_MESSAGES || table == DataContainer.PRIVATE_MESSAGES) {
            throw new IllegalArgumentException("Unable to set data to table " + table.getDatabaseTableID() + " using an ID since that table does not have IDs");
        }
        this.executeUpdate("UPDATE " + table.getDatabaseTableID() + " SET " + column + " = ? WHERE " + table.getIDColumn() + " = ?", data, id);
    }

    @Override
    public List<Integer> getIDs(DataContainer table) throws SQLException {
        if (table == DataContainer.PUBLIC_MESSAGES || table == DataContainer.PRIVATE_MESSAGES) {
            throw new IllegalArgumentException("Unable to get IDs in table " + table.getDatabaseTableID() + " since that table does not have IDs");
        }
        return this.getColumnValues("SELECT " + table.getIDColumn() + " FROM " + table.getDatabaseTableID(), 1, Number.class, new Object[0]).stream().map(Integer.class::cast).collect(Collectors.toList());
    }

    @Override
    public void removeEntry(DataContainer table, int id) throws SQLException {
        if (table == DataContainer.PUBLIC_MESSAGES || table == DataContainer.PRIVATE_MESSAGES) {
            throw new IllegalArgumentException("Unable to remove entry in table " + table.getDatabaseTableID() + " using an ID since that table does not have IDs");
        }
        this.executeUpdate("DELETE FROM " + table.getDatabaseTableID() + " WHERE " + table.getIDColumn() + " = ?", id);
    }

    @Override
    public <T> T getPlayerData(PlayersDataType<T> type, OfflinePlayer player) throws SQLException {
        boolean onlineMode = ChatPlugin.getInstance().isOnlineMode();
        return this.convertNumber(this.get("SELECT " + type.getDatabaseTableID() + " FROM " + DataContainer.PLAYERS.getDatabaseTableID() + " WHERE player_" + (onlineMode ? "uuid" : "name") + " = ?", type.getDatabaseTableID(), type.getType(), onlineMode ? player.getUUID().toString() : player.getName()), type);
    }

    @Override
    public <T> T getPlayerData(PlayersDataType<T> type, int playerID) throws SQLException {
        return this.convertNumber(this.get("SELECT " + type.getDatabaseTableID() + " FROM " + DataContainer.PLAYERS.getDatabaseTableID() + " WHERE id = ?", type.getDatabaseTableID(), type.getType(), playerID), type);
    }

    @Override
    public void setPlayerData(PlayersDataType<?> type, OfflinePlayer player, Object data) throws SQLException {
        if (type == PlayersDataType.ID) {
            throw new IllegalArgumentException("Unable to change a player's ID");
        }
        if (this.isPlayerStored(player)) {
            boolean onlineMode = ChatPlugin.getInstance().isOnlineMode();
            this.executeUpdate("UPDATE " + DataContainer.PLAYERS.getDatabaseTableID() + " SET " + type.getDatabaseTableID() + " = ? WHERE player_" + (onlineMode ? "uuid" : "name") + " = ?", data, onlineMode ? player.getUUID().toString() : player.getName());
        } else {
            LogManager.log("The plugin tried to write data into the database (table: {0}, column: {1}) for a player ({2}) who has never played on the server. Data: \"{3}\".", 2, DataContainer.PLAYERS.getDatabaseTableID(), type.getDatabaseTableID(), player.getName(), String.valueOf(data));
        }
    }

    @Override
    public void setPlayerData(PlayersDataType<?> type, int playerID, Object data) throws SQLException, IOException {
        if (type == PlayersDataType.ID) {
            throw new IllegalArgumentException("Unable to change a player's ID");
        }
        if (this.isPlayerStored(playerID)) {
            this.executeUpdate("UPDATE " + DataContainer.PLAYERS.getDatabaseTableID() + " SET " + type.getDatabaseTableID() + " = ? WHERE id = ?", data, playerID);
        } else {
            LogManager.log("The plugin tried to write data into the database (table: {0}, column: {1}) for a player (ID: #{2}) who has never played on the server. Data: \"{3}\".", 2, DataContainer.PLAYERS.getDatabaseTableID(), type.getDatabaseTableID(), playerID, String.valueOf(data));
        }
    }

    @Override
    public List<OfflinePlayer> getPlayers(InetAddress ipAddress, boolean includeOlder) throws SQLException {
        ArrayList<OfflinePlayer> list = new ArrayList<OfflinePlayer>();
        List<String> uuids = this.getColumnValues("SELECT player_uuid FROM " + DataContainer.PLAYERS.getDatabaseTableID() + " WHERE player_ip = ?", "player_uuid", String.class, ipAddress.getHostAddress());
        List<String> names = this.getColumnValues("SELECT player_name FROM " + DataContainer.PLAYERS.getDatabaseTableID() + " WHERE player_ip = ?", "player_name", String.class, ipAddress.getHostAddress());
        for (int i = 0; i < uuids.size(); ++i) {
            list.add(new OfflinePlayer(UUID.fromString(uuids.get(i)), names.get(i)));
        }
        if (includeOlder) {
            for (Number id : this.getColumnValues("SELECT player_id FROM " + DataContainer.IP_ADDRESSES.getDatabaseTableID() + " WHERE player_ip LIKE ?", "player_id", Number.class, "%" + ipAddress.getHostAddress() + "%")) {
                list.add(this.getPlayer(id.intValue()));
            }
        }
        return list;
    }

    @Override
    public void insertNewPlayer(OfflinePlayer player) throws SQLException {
        this.executeUpdate("INSERT INTO " + DataContainer.PLAYERS.getDatabaseTableID() + " (player_uuid, player_name) VALUES (?, ?)", player.getUUID().toString(), player.getName());
        if (player.isOnline()) {
            this.executeUpdate("UPDATE " + DataContainer.PLAYERS.getDatabaseTableID() + " SET player_ip = ? WHERE player_uuid = ?", player.getIPAddress().getHostAddress(), player.getUUID().toString());
            if (Environment.isBukkit()) {
                this.executeUpdate("UPDATE " + DataContainer.PLAYERS.getDatabaseTableID() + " SET time_played = ? WHERE player_uuid = ?", player.toAdapter().bukkitValue().getStatistic(Statistic.valueOf((String)(VersionUtils.getVersion().getProtocol() < 341 ? "PLAY_ONE_TICK" : "PLAY_ONE_MINUTE"))) * 50, player.getUUID().toString());
            } else if (Environment.isSponge() && player.toAdapter().spongeValue().getStatisticData().get(Keys.STATISTICS).isPresent()) {
                this.executeUpdate("UPDATE " + DataContainer.PLAYERS.getDatabaseTableID() + " SET time_played = ? WHERE player_uuid = ?", ((Map)player.toAdapter().spongeValue().getStatisticData().get(Keys.STATISTICS).get()).getOrDefault(Statistics.TIME_PLAYED, 0L) * 50L, player.getUUID().toString());
            }
        }
    }

    @Override
    public void cleanOldPlayers() {
        if (StorageManager.getInstance().getPlayersAutoCleanerPeriod() != -1L) {
            TaskManager.runAsync(() -> {
                long ms = System.currentTimeMillis();
                int old = 0;
                try {
                    for (Number id : this.getColumnValues("SELECT id FROM " + DataContainer.PLAYERS.getDatabaseTableID() + " WHERE last_logout IS NOT NULL AND last_logout < ?", "id", Number.class, System.currentTimeMillis() - StorageManager.getInstance().getPlayersAutoCleanerPeriod())) {
                        this.executeUpdate("DELETE FROM " + DataContainer.PLAYERS.getDatabaseTableID() + " WHERE id = ?", id.intValue());
                        this.executeUpdate("DELETE FROM " + DataContainer.IP_ADDRESSES.getDatabaseTableID() + " WHERE id = ?", id.intValue());
                        ++old;
                    }
                }
                catch (SQLException e) {
                    LogManager.log("SQLException occurred while cleaning old players from the database: {0}", 2, e.getMessage());
                }
                if (old > 0) {
                    LogManager.log("[ASYNC] Cleaned {0} old player{1} from the database in {2} ms.", 4, old, old == 1 ? "" : "s", System.currentTimeMillis() - ms);
                }
            }, 0L);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void checkConnection() {
        try {
            if (this.connection.isClosed() || !this.connection.isValid(0)) {
                LogManager.log("Connection to database timed out; reconnecting.", 3, new Object[0]);
                this.load();
            }
            return;
        }
        catch (SQLException e) {
            LogManager.log("SQLException occurred while trying to access the database: {0}", 2, e.getMessage());
        }
        catch (ChatPluginManagerException e) {
            LogManager.log("Error occurred while reloading the database connector after a period of inactivity: {0}", 2, e.getMessage());
        }
        ChatPlugin.getInstance().unload();
    }

    public PreparedStatement prepareStatement(String sql, Object ... params) throws SQLException {
        this.checkConnection();
        PreparedStatement statement = this.connection.prepareStatement(sql);
        for (int i = 0; i < params.length; ++i) {
            statement.setObject(i + 1, params[i]);
        }
        return statement;
    }

    public int executeUpdate(String sql, Object ... params) throws SQLException {
        try (PreparedStatement statement = this.prepareStatement(sql, params);){
            int i = statement.executeUpdate();
            statement.clearParameters();
            int n = i;
            return n;
        }
    }

    public <T> T get(String query, String columnLabel, Class<T> type, Object ... params) throws SQLException {
        try (PreparedStatement statement = this.prepareStatement(query, params);){
            statement.execute();
            ResultSet result = statement.getResultSet();
            if (!result.next()) {
                T t = null;
                return t;
            }
            Object t = result.getObject(columnLabel);
            statement.clearParameters();
            Object object = t;
            return (T)object;
        }
    }

    public <T> T safeGet(String query, String columnLabel, T def, Object ... params) {
        try {
            return (T)this.get(query, columnLabel, Object.class, params);
        }
        catch (SQLException e) {
            return def;
        }
    }

    public <T> T get(String query, int columnIndex, Class<T> type, Object ... params) throws SQLException {
        try (PreparedStatement statement = this.prepareStatement(query, params);){
            statement.execute();
            ResultSet result = statement.getResultSet();
            if (!result.next()) {
                T t = null;
                return t;
            }
            Object t = result.getObject(columnIndex);
            statement.clearParameters();
            Object object = t;
            return (T)object;
        }
    }

    public <T> T safeGet(String query, int columnIndex, T def, Object ... params) {
        try {
            return (T)this.get(query, columnIndex, Object.class, params);
        }
        catch (SQLException e) {
            return def;
        }
    }

    public <T> List<T> getColumnValues(String query, String columnLabel, Class<T> type, Object ... params) throws SQLException {
        ArrayList<Object> list = new ArrayList<Object>();
        try (PreparedStatement statement = this.prepareStatement(query, params);){
            statement.execute();
            ResultSet result = statement.getResultSet();
            while (result.next()) {
                list.add(result.getObject(columnLabel));
            }
            statement.clearParameters();
        }
        return list;
    }

    public <T> List<T> getColumnValues(String query, int columnIndex, Class<T> type, Object ... params) throws SQLException {
        ArrayList<Object> list = new ArrayList<Object>();
        try (PreparedStatement statement = this.prepareStatement(query, params);){
            statement.execute();
            ResultSet result = statement.getResultSet();
            while (result.next()) {
                list.add(result.getObject(columnIndex));
            }
            statement.clearParameters();
        }
        return list;
    }

    public static DatabaseConnector getInstance() {
        return (DatabaseConnector)instance;
    }
}

