/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.storage.configuration;

import java.io.File;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.remigio07.chatplugin.api.ChatPlugin;
import me.remigio07.chatplugin.api.common.storage.configuration.Configuration;
import me.remigio07.chatplugin.api.common.storage.configuration.ConfigurationManager;
import me.remigio07.chatplugin.bootstrap.Environment;

public enum ConfigurationType {
    CONFIG,
    MESSAGES,
    RANKS,
    CHAT,
    TABLISTS,
    DEFAULT_SCOREBOARD,
    BOSSBARS,
    ACTIONBARS,
    ADS,
    F3_SERVER_NAMES,
    JOIN_QUIT_MODULES,
    MAIN_GUI,
    LANGUAGES_GUI,
    CHAT_COLOR_GUI,
    EMOJIS_TONE_GUI,
    BANLIST_GUI,
    WARNLIST_GUI,
    MUTELIST_GUI,
    VIOLATIONS_GUI,
    PLAYER_INFO_GUI,
    PLAYER_PUNISHMENTS_GUI,
    PLAYER_VIOLATIONS_GUI,
    PREFERENCES_GUI,
    VIOLATIONS_ICONS,
    MOTD,
    DISCORD_INTEGRATION,
    TELEGRAM_INTEGRATION,
    CUSTOM;


    public String getFolder() {
        return this == DEFAULT_SCOREBOARD ? "scoreboards" : (this == VIOLATIONS_ICONS || this.name().contains("GUI") ? "guis" : null);
    }

    public String getFileName() {
        return this == DEFAULT_SCOREBOARD ? "default.yml" : this.name().toLowerCase().replace('_', '-').substring(0, this.name().endsWith("_GUI") ? this.name().length() - 4 : this.name().length()) + ".yml";
    }

    public Path toPath() {
        String folder = this.getFolder();
        return ChatPlugin.getInstance().getDataFolder().resolve((folder == null ? "" : folder + File.separator) + this.getFileName());
    }

    public Configuration get() {
        return ConfigurationManager.getInstance().getConfiguration(this);
    }

    public boolean isAvailableOnProxy() {
        return this == CONFIG || this == CUSTOM || this.name().endsWith("_INTEGRATION");
    }

    public static Set<ConfigurationType> getConfigurationTypes() {
        return Stream.of(ConfigurationType.values()).filter(type -> !Environment.isProxy() || type.isAvailableOnProxy()).collect(Collectors.toCollection(() -> EnumSet.noneOf(ConfigurationType.class)));
    }
}

