/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.storage.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import me.remigio07.chatplugin.api.common.util.text.ChatColor;

public class ConfigurationMappings {
    private Map<String, Object> mappings = new LinkedHashMap<String, Object>();

    private ConfigurationMappings() {
    }

    ConfigurationMappings(Map<String, Object> mappings) {
        for (Map.Entry<String, Object> entry : mappings.entrySet()) {
            String key;
            String string = key = entry.getKey() == null ? "null" : entry.getKey().toString();
            if (entry.getValue() instanceof Map) {
                this.mappings.put(key, new ConfigurationMappings((Map)entry.getValue()));
                continue;
            }
            this.mappings.put(key, entry.getValue());
        }
    }

    public Map<String, Object> getMappings() {
        return this.mappings;
    }

    public <T> T get(String path, T def) {
        ConfigurationMappings section = this.getSectionFor(path, false);
        if (section == null) {
            return def;
        }
        Object value = section == this ? this.mappings.get(path) : section.get(this.getChild(path), def);
        if (value == null && def instanceof ConfigurationMappings) {
            this.mappings.put(path, def);
        }
        return (T)(value == null ? def : value);
    }

    public String getChild(String path) {
        int index = path.indexOf(46);
        return index == -1 ? path : path.substring(index + 1);
    }

    public ConfigurationMappings getSection(String path) {
        return this.get(path, null);
    }

    private ConfigurationMappings getSectionFor(String path, boolean put) {
        int index = path.indexOf(46);
        if (index == -1) {
            return this;
        }
        String root = path.substring(0, index);
        Object section = this.mappings.get(root);
        if (section == null) {
            section = new ConfigurationMappings();
            if (put) {
                this.mappings.put(root, section);
            }
        }
        return section instanceof ConfigurationMappings ? (ConfigurationMappings)section : null;
    }

    public List<String> getKeys() {
        return new ArrayList<String>(new LinkedHashSet<String>(this.mappings.keySet()));
    }

    public List<String> getKeys(String path) {
        ConfigurationMappings section = this.getSection(path);
        return new ArrayList<String>(section == null ? Collections.emptyList() : section.getKeys());
    }

    public boolean contains(String path) {
        return this.get(path, null) != null;
    }

    public void addDefault(String path, Object value) {
        if (!this.contains(path)) {
            this.set(path, value);
        }
    }

    public void set(String path, Object value) {
        ConfigurationMappings section;
        if (value instanceof Map) {
            value = new ConfigurationMappings((Map)value);
        }
        if ((section = this.getSectionFor(path, true)) != null) {
            if (section == this) {
                if (value == null) {
                    this.mappings.remove(path);
                } else {
                    this.mappings.put(path, value);
                }
            } else {
                section.set(this.getChild(path), value);
            }
        }
    }

    public boolean getBoolean(String path) {
        return this.getBoolean(path, false);
    }

    public boolean getBoolean(String path, boolean def) {
        Boolean value = this.get(path, def);
        return value instanceof Boolean ? value : def;
    }

    public byte getByte(String path) {
        return this.getByte(path, (byte)0);
    }

    public byte getByte(String path, byte def) {
        Byte value = this.get(path, def);
        return value instanceof Number ? ((Number)value).byteValue() : def;
    }

    public short getShort(String path) {
        return this.getShort(path, (short)0);
    }

    public short getShort(String path, short def) {
        Short value = this.get(path, def);
        return value instanceof Number ? ((Number)value).shortValue() : def;
    }

    public int getInt(String path) {
        return this.getInt(path, 0);
    }

    public int getInt(String path, int def) {
        Integer value = this.get(path, def);
        return value instanceof Number ? ((Number)value).intValue() : def;
    }

    public long getLong(String path) {
        return this.getLong(path, 0L);
    }

    public long getLong(String path, long def) {
        Long value = this.get(path, def);
        return value instanceof Number ? ((Number)value).longValue() : def;
    }

    public float getFloat(String path) {
        return this.getFloat(path, 0.0f);
    }

    public float getFloat(String path, float def) {
        Float value = this.get(path, Float.valueOf(def));
        return value instanceof Number ? ((Number)value).floatValue() : def;
    }

    public double getDouble(String path) {
        return this.getDouble(path, 0.0);
    }

    public double getDouble(String path, double def) {
        Double value = this.get(path, def);
        return value instanceof Number ? ((Number)value).doubleValue() : def;
    }

    public String getString(String path) {
        return this.getString(path, "");
    }

    public String getString(String path, String def) {
        String value = this.get(path, def);
        return value instanceof String ? value : def;
    }

    public List<?> getList(String path) {
        return this.getList(path, new ArrayList());
    }

    public <T> List<T> getList(String path, List<T> def) {
        List<T> value = this.get(path, def);
        try {
            return value;
        }
        catch (ClassCastException e) {
            return def;
        }
    }

    public List<Boolean> getBooleanList(String path) {
        return this.getList(path, new ArrayList());
    }

    public List<Byte> getByteList(String path) {
        return this.getList(path, new ArrayList());
    }

    public List<Short> getShortList(String path) {
        return this.getList(path, new ArrayList());
    }

    public List<Integer> getIntegerList(String path) {
        return this.getList(path, new ArrayList());
    }

    public List<Long> getLongList(String path) {
        return this.getList(path, new ArrayList());
    }

    public List<Float> getFloatList(String path) {
        return this.getList(path, new ArrayList());
    }

    public List<Double> getDoubleList(String path) {
        return this.getList(path, new ArrayList());
    }

    public List<String> getStringList(String path) {
        return this.getList(path, new ArrayList());
    }

    public String translateString(String path) {
        return this.translateString(path, "");
    }

    public String translateString(String path, String def) {
        return this.translateString(path, def, true);
    }

    public String translateString(String path, String def, boolean retainNewLines) {
        return this.contains(path) || def != null ? ChatColor.translate(this.getString(path, def), retainNewLines) : null;
    }

    public List<String> translateStringList(String path) {
        return this.translateStringList(path, new ArrayList<String>());
    }

    public List<String> translateStringList(String path, List<String> def) {
        return this.translateStringList(path, def, true);
    }

    public List<String> translateStringList(String path, List<String> def, boolean retainNewLines) {
        return this.contains(path) || def != null ? ChatColor.translate(this.getList(path, def), retainNewLines) : null;
    }
}

