/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.storage.configuration;

import java.io.IOException;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.Map;
import me.remigio07.chatplugin.api.common.storage.configuration.Configuration;
import me.remigio07.chatplugin.api.common.storage.configuration.ConfigurationType;
import me.remigio07.chatplugin.api.common.util.VersionChange;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManager;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManagerException;
import me.remigio07.chatplugin.api.common.util.manager.LogManager;

public abstract class ConfigurationManager
implements ChatPluginManager {
    protected static ConfigurationManager instance;
    protected boolean enabled;
    protected Map<ConfigurationType, Configuration> configurations = new EnumMap<ConfigurationType, Configuration>(ConfigurationType.class);
    protected VersionChange lastVersionChange;
    protected String path;
    protected long loadTime;

    @Override
    public void unload() throws ChatPluginManagerException {
        this.enabled = false;
        this.configurations.clear();
        this.path = null;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public Map<ConfigurationType, Configuration> getConfigurations() {
        return this.configurations;
    }

    public Configuration getConfiguration(ConfigurationType type) {
        return this.configurations.get((Object)type);
    }

    public void loadAll() throws IOException {
        long ms = System.currentTimeMillis();
        for (Configuration configuration : this.configurations.values()) {
            configuration.load();
        }
        LogManager.log("Loaded {0} configuration files in {1} ms.", 4, this.configurations.size(), System.currentTimeMillis() - ms);
    }

    protected void putConfiguration(Configuration configuration) {
        this.configurations.put(configuration.getType(), configuration);
    }

    public VersionChange getLastVersionChange() {
        return this.lastVersionChange;
    }

    public static ConfigurationManager getInstance() {
        return instance;
    }

    public abstract Configuration createConfiguration(Path var1);
}

