/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.storage;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import me.remigio07.chatplugin.api.ChatPlugin;
import me.remigio07.chatplugin.api.common.storage.StorageConnector;
import me.remigio07.chatplugin.api.common.storage.StorageMethod;
import me.remigio07.chatplugin.api.common.storage.configuration.ConfigurationType;
import me.remigio07.chatplugin.api.common.util.Utils;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManager;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManagerException;

public abstract class StorageManager
implements ChatPluginManager {
    protected static StorageManager instance;
    protected StorageConnector connector;
    protected boolean enabled;
    protected StorageMethod method;
    protected Path folder;
    protected long playersAutoCleanerPeriod = -1L;
    protected long loadTime;
    protected String engine;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void load() throws ChatPluginManagerException {
        try {
            this.folder = Paths.get(ConfigurationType.CONFIG.get().getString("storage.folder").replace("{0}", ChatPlugin.getInstance().getDataFolder().toAbsolutePath().toString()), new String[0]);
            Files.createDirectories(this.folder, new FileAttribute[0]);
        }
        catch (IOException | InvalidPathException e) {
            throw new ChatPluginManagerException(this, e);
        }
        this.method = StorageMethod.valueOf(ConfigurationType.CONFIG.get().getString("storage.method").toUpperCase());
        this.playersAutoCleanerPeriod = Utils.getTime(ConfigurationType.CONFIG.get().getString("storage.players-auto-cleaner-period"), false, false);
    }

    @Override
    public void unload() throws ChatPluginManagerException {
        this.enabled = false;
        try {
            this.connector.unload();
        }
        catch (IOException | SQLException e) {
            throw new ChatPluginManagerException(this, e);
        }
        this.connector = null;
        this.method = null;
        this.folder = null;
        this.playersAutoCleanerPeriod = -1L;
        this.engine = null;
    }

    public StorageConnector getConnector() {
        return this.connector;
    }

    public StorageMethod getMethod() {
        return this.method;
    }

    public Path getFolder() {
        return this.folder;
    }

    public long getPlayersAutoCleanerPeriod() {
        return this.playersAutoCleanerPeriod;
    }

    public static StorageManager getInstance() {
        return instance;
    }
}

