/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.storage;

import java.io.IOException;
import java.net.InetAddress;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import me.remigio07.chatplugin.api.common.player.OfflinePlayer;
import me.remigio07.chatplugin.api.common.punishment.ban.Ban;
import me.remigio07.chatplugin.api.common.punishment.kick.Kick;
import me.remigio07.chatplugin.api.common.punishment.mute.Mute;
import me.remigio07.chatplugin.api.common.punishment.warning.Warning;
import me.remigio07.chatplugin.api.common.punishment.warning.WarningManager;
import me.remigio07.chatplugin.api.common.storage.DataContainer;
import me.remigio07.chatplugin.api.common.storage.PlayersDataType;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManagerException;
import me.remigio07.chatplugin.api.server.chat.log.LoggedMessage;
import me.remigio07.chatplugin.api.server.chat.log.LoggedPrivateMessage;
import me.remigio07.chatplugin.api.server.chat.log.LoggedPublicMessage;

public abstract class StorageConnector {
    protected static StorageConnector instance;

    public void incrementPlayerStat(PlayersDataType<? extends Number> type, OfflinePlayer player) throws SQLException, IOException {
        if (type.ordinal() <= PlayersDataType.MESSAGES_SENT.ordinal() - 1) {
            throw new IllegalArgumentException("Specified column type does not represent a stat: " + type.name());
        }
        Number stat = this.getPlayerData(type, player);
        this.setPlayerData(type, player, (Object)(stat == null ? 0 : (stat instanceof Short ? stat.shortValue() : stat.intValue()) + 1));
    }

    public boolean isPlayerStored(OfflinePlayer player) throws SQLException {
        return this.getPlayerData(PlayersDataType.PLAYER_NAME, player) != null;
    }

    public boolean isPlayerStored(int playerID) throws SQLException {
        return this.getPlayerData(PlayersDataType.PLAYER_NAME, playerID) != null;
    }

    public boolean isPlayerIPStored(OfflinePlayer player) throws SQLException {
        return this.getPlayerData(PlayersDataType.PLAYER_IP, player) != null;
    }

    public OfflinePlayer getPlayer(int playerID) throws SQLException {
        return this.isPlayerStored(playerID) ? new OfflinePlayer(UUID.fromString(this.getPlayerData(PlayersDataType.PLAYER_UUID, playerID)), this.getPlayerData(PlayersDataType.PLAYER_NAME, playerID)) : null;
    }

    public void clearWarnings(OfflinePlayer player) throws SQLException, IOException {
        for (Warning warning : WarningManager.getInstance().getActiveWarnings(player)) {
            this.disactiveWarning(warning);
        }
    }

    public void insertNewBan(Ban ban) throws SQLException, IOException {
        throw new UnsupportedOperationException("Unable to insert a ban in the storage on the free version");
    }

    public void updateBan(Ban oldBan, Ban newBan) throws SQLException, IOException {
        throw new UnsupportedOperationException("Unable to update a ban in the storage on the free version");
    }

    public void disactiveBan(Ban ban) throws SQLException, IOException {
        throw new UnsupportedOperationException("Unable to disactive a ban in the storage on the free version");
    }

    public Ban getBan(int id) throws SQLException {
        throw new UnsupportedOperationException("Unable to get a ban from the storage on the free version");
    }

    public void insertNewWarning(Warning warning) throws SQLException, IOException {
        throw new UnsupportedOperationException("Unable to insert a warning in the storage on the free version");
    }

    public void disactiveWarning(Warning warning) throws SQLException, IOException {
        throw new UnsupportedOperationException("Unable to disactive a warning in the storage on the free version");
    }

    public Warning getWarning(int id) throws SQLException {
        throw new UnsupportedOperationException("Unable to get a warning from the storage on the free version");
    }

    public void insertNewKick(Kick kick) throws SQLException, IOException {
        throw new UnsupportedOperationException("Unable to insert a kick in the storage on the free version");
    }

    public Kick getKick(int id) throws SQLException {
        throw new UnsupportedOperationException("Unable to get a kick from the storage on the free version");
    }

    public void insertNewMute(Mute mute) throws SQLException, IOException {
        throw new UnsupportedOperationException("Unable to insert a mute in the storage on the free version");
    }

    public void updateMute(Mute oldMute, Mute newMute) throws SQLException, IOException {
        throw new UnsupportedOperationException("Unable to update a mute in the storage on the free version");
    }

    public void disactiveMute(Mute mute) throws SQLException, IOException {
        throw new UnsupportedOperationException("Unable to disactive a mute in the storage on the free version");
    }

    public Mute getMute(int id) throws SQLException {
        throw new UnsupportedOperationException("Unable to get a mute from the storage on the free version");
    }

    public void insertNewMessage(LoggedMessage message) throws SQLException, IOException {
        throw new UnsupportedOperationException("Unable to insert a message in the storage on the free version");
    }

    public List<LoggedPublicMessage> getPublicMessages(OfflinePlayer sender, long timeAgo, String query) throws SQLException {
        throw new UnsupportedOperationException("Unable to get public messages from the storage on the free version");
    }

    public List<LoggedPrivateMessage> getPrivateMessages(OfflinePlayer sender, long timeAgo, String query) throws SQLException {
        throw new UnsupportedOperationException("Unable to get private messages from the storage on the free version");
    }

    public void cleanOldMessages() {
        throw new UnsupportedOperationException("Unable to clean old messages from the storage on the free version");
    }

    protected <T> T convertNumber(Object data, PlayersDataType<T> type) {
        if (data instanceof Number) {
            if (type.getType() == Long.TYPE) {
                return (T)Long.valueOf(((Number)data).longValue());
            }
            if (type.getType() == Integer.TYPE) {
                return (T)Integer.valueOf(((Number)data).intValue());
            }
            return (T)Short.valueOf(((Number)data).shortValue());
        }
        return (T)data;
    }

    public static StorageConnector getInstance() {
        return instance;
    }

    public abstract void load() throws ChatPluginManagerException;

    public abstract void unload() throws SQLException, IOException;

    public abstract <T> T select(DataContainer var1, String var2, Class<T> var3, WhereCondition ... var4) throws SQLException;

    public abstract Number count(DataContainer var1, WhereCondition ... var2) throws SQLException;

    public abstract int update(DataContainer var1, String var2, Object var3, WhereCondition ... var4) throws SQLException, IOException;

    public abstract int delete(DataContainer var1, WhereCondition ... var2) throws SQLException, IOException;

    public abstract <T> List<T> getColumnValues(DataContainer var1, String var2, Class<T> var3, WhereCondition ... var4) throws SQLException;

    public abstract List<Object> getRowValues(DataContainer var1, int var2) throws SQLException;

    public abstract Set<DataContainer> getMissingDataContainers() throws SQLException;

    public abstract void createDataContainer(DataContainer var1) throws SQLException, IOException;

    public abstract void setData(DataContainer var1, String var2, int var3, Object var4) throws SQLException, IOException;

    public abstract List<Integer> getIDs(DataContainer var1) throws SQLException;

    public abstract int getNextID(DataContainer var1) throws SQLException;

    public abstract void removeEntry(DataContainer var1, int var2) throws SQLException, IOException;

    public abstract <T> T getPlayerData(PlayersDataType<T> var1, OfflinePlayer var2) throws SQLException;

    public abstract <T> T getPlayerData(PlayersDataType<T> var1, int var2) throws SQLException;

    public abstract void setPlayerData(PlayersDataType<?> var1, OfflinePlayer var2, Object var3) throws SQLException, IOException;

    public abstract void setPlayerData(PlayersDataType<?> var1, int var2, Object var3) throws SQLException, IOException;

    public abstract List<OfflinePlayer> getPlayers(InetAddress var1, boolean var2) throws SQLException;

    public abstract void insertNewPlayer(OfflinePlayer var1) throws SQLException, IOException;

    public abstract void cleanOldPlayers();

    public abstract String getEngineName();

    public abstract String getEngineVersion() throws SQLException;

    public static class WhereCondition {
        private String firstTermPosition;
        private WhereOperator operator;
        private Object secondTermValue;

        public WhereCondition(String firstTermPosition, WhereOperator operator, Object secondTermValue) {
            this.firstTermPosition = firstTermPosition;
            this.operator = operator;
            this.secondTermValue = secondTermValue;
        }

        public String getFirstTermPosition() {
            return this.firstTermPosition;
        }

        public WhereOperator getOperator() {
            return this.operator;
        }

        public Object getSecondTermValue() {
            return this.secondTermValue;
        }

        public static enum WhereOperator {
            EQUAL("="),
            NOT_EQUAL("<>"),
            GREATER_THAN(">"),
            LESS_THAN("<"),
            GREATER_THAN_OR_EQUAL(">="),
            LESS_THAN_OR_EQUAL("<=");

            private String toString;

            private WhereOperator(String toString) {
                this.toString = toString;
            }

            public String toString() {
                return this.toString;
            }
        }
    }
}

