/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.storage;

import java.nio.file.Path;
import me.remigio07.chatplugin.api.common.storage.StorageManager;
import me.remigio07.chatplugin.api.common.storage.StorageMethod;
import me.remigio07.chatplugin.api.common.storage.database.DatabaseManager;

public enum DataContainer {
    BANS("id", "player_uuid", "player_name", "player_ip", "staff_member", "who_unbanned", "reason", "server", "type", "date", "unban_date", "duration", "global", "silent", "active", "unbanned"),
    WARNINGS("id", "player_uuid", "player_name", "staff_member", "who_unwarned", "reason", "server", "date", "unwarn_date", "duration", "global", "silent", "active", "unwarned"),
    KICKS("id", "player_uuid", "player_name", "player_ip", "staff_member", "reason", "server", "type", "date", "silent"),
    MUTES("id", "player_uuid", "player_name", "staff_member", "who_unmuted", "reason", "server", "date", "unmute_date", "duration", "global", "silent", "active", "unmuted"),
    PLAYERS("id", "player_uuid", "player_name", "player_ip", "language", "ignored_players", "chat_color", "emojis_tone", "last_logout", "time_played", "messages_sent", "bans", "warnings", "kicks", "mutes"),
    PUBLIC_MESSAGES("player_uuid", "player_name", "rank_id", "server", "world", "channel_id", "message", "date", "deny_chat_reason"),
    PRIVATE_MESSAGES("player_uuid", "player_name", "recipient", "rank_id", "server", "world", "message", "date", "deny_chat_reason"),
    IP_ADDRESSES("player_id", "ip_addresses");

    private String[] columns;

    private DataContainer(String ... columns) {
        this.columns = columns;
    }

    public String getName() {
        return this.name().toLowerCase().replace('_', '-');
    }

    public String getDatabaseTableID() {
        return DatabaseManager.getTablePrefix() + this.name().toLowerCase();
    }

    public String getIDColumn() {
        return this == PUBLIC_MESSAGES || this == PRIVATE_MESSAGES ? "N/A" : (this == IP_ADDRESSES ? "player_id" : "id");
    }

    public String[] getColumns() {
        return this.columns;
    }

    public Path getFlatFile() {
        StorageMethod method = StorageManager.getInstance().getMethod();
        if (method.isFlatFile()) {
            return StorageManager.getInstance().getFolder().resolve(this.getName() + (method == StorageMethod.YAML ? ".yml" : ".json"));
        }
        throw new UnsupportedOperationException("Unable to obtain a data container's file when using " + method.getName() + " as storage method.");
    }

    public static DataContainer getDataContainer(String databaseTableID) {
        for (DataContainer type : DataContainer.values()) {
            if (!type.getDatabaseTableID().equalsIgnoreCase(databaseTableID)) continue;
            return type;
        }
        return null;
    }
}

