/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.punishment.warning;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import me.remigio07.chatplugin.api.common.player.OfflinePlayer;
import me.remigio07.chatplugin.api.common.punishment.PunishmentManager;
import me.remigio07.chatplugin.api.common.punishment.warning.Warning;
import me.remigio07.chatplugin.api.server.language.Language;

public abstract class WarningManager
extends PunishmentManager {
    protected static WarningManager instance;
    protected List<Warning> warnings = new CopyOnWriteArrayList<Warning>();
    protected Map<Integer, Map<Language, List<String>>> punishCommands = new HashMap<Integer, Map<Language, List<String>>>();
    protected boolean defaultGlobal;
    protected long duration;
    protected int maxAmount;
    protected long loadTime;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public List<Warning> getActiveWarnings() {
        return this.warnings;
    }

    public Map<Integer, Map<Language, List<String>>> getPunishCommands() {
        return this.punishCommands;
    }

    public boolean isAmountPunished(int amount) {
        return this.punishCommands.containsKey(amount);
    }

    public int getMaxAmount() {
        return this.maxAmount;
    }

    public boolean isDefaultGlobal() {
        return this.defaultGlobal;
    }

    public long getDuration() {
        return this.duration;
    }

    public boolean isWarned(OfflinePlayer player, String server) {
        return !this.getActiveWarnings(player, server).isEmpty();
    }

    public static WarningManager getInstance() {
        return instance;
    }

    public abstract void warn(OfflinePlayer var1, String var2, String var3, String var4, long var5, boolean var7, boolean var8);

    public abstract void unwarn(int var1, String var2);

    public abstract void removeLastWarning(OfflinePlayer var1, String var2, String var3);

    public abstract void clearWarnings(OfflinePlayer var1, String var2, String var3);

    public abstract List<Warning> getActiveWarnings(OfflinePlayer var1);

    public abstract List<Warning> getActiveWarnings(OfflinePlayer var1, String var2);

    public abstract Warning getActiveWarning(int var1);

    public abstract Warning getWarning(int var1);

    public abstract List<String> getPunishCommands(int var1, Language var2);

    public abstract String formatActiveMessage(boolean var1, Language var2);

    public abstract String formatGlobalMessage(boolean var1, Language var2);

    public abstract String formatSilentMessage(boolean var1, Language var2);
}

