/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.player;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.remigio07.chatplugin.api.common.player.ChatPluginPlayer;
import me.remigio07.chatplugin.api.common.storage.configuration.ConfigurationType;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManager;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManagerException;

public abstract class PlayerManager
implements ChatPluginManager {
    protected static PlayerManager instance;
    protected boolean enabled;
    protected String floodgateUsernamePrefix;
    protected Pattern usernamePattern;
    protected TimeZone displayedTimeZone;
    protected long loadTime;

    @Override
    public void load() throws ChatPluginManagerException {
        this.usernamePattern = Pattern.compile("^(?=.{2,16}$)(?:" + Pattern.quote(this.floodgateUsernamePrefix) + "\\w{1," + (16 - this.floodgateUsernamePrefix.length()) + "}|\\w{2,})$");
        String tz = ConfigurationType.CONFIG.get().getString("settings.displayed-time-zone");
        this.displayedTimeZone = tz.isEmpty() ? TimeZone.getDefault() : TimeZone.getTimeZone(tz);
    }

    @Override
    public void unload() {
        this.floodgateUsernamePrefix = null;
        this.usernamePattern = null;
        this.displayedTimeZone = null;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public List<String> getPlayersNames() {
        return this.getPlayers().values().stream().map(ChatPluginPlayer::getName).collect(Collectors.toList());
    }

    public List<InetAddress> getPlayersIPs() {
        ArrayList<InetAddress> ips = new ArrayList<InetAddress>();
        for (ChatPluginPlayer chatPluginPlayer : this.getPlayers().values()) {
            if (ips.contains(chatPluginPlayer.getIPAddress())) continue;
            ips.add(chatPluginPlayer.getIPAddress());
        }
        return ips;
    }

    public String getFloodgateUsernamePrefix() {
        return this.floodgateUsernamePrefix;
    }

    public Pattern getUsernamePattern() {
        return this.usernamePattern;
    }

    public boolean isValidUsername(String username) {
        return this.usernamePattern.matcher(username).matches();
    }

    public TimeZone getDisplayedTimeZone() {
        return this.displayedTimeZone;
    }

    public static PlayerManager getInstance() {
        return instance;
    }

    public abstract Map<UUID, ? extends ChatPluginPlayer> getPlayers();

    public abstract List<? extends ChatPluginPlayer> getPlayers(InetAddress var1);

    public abstract ChatPluginPlayer getPlayer(UUID var1);

    @Deprecated
    public abstract ChatPluginPlayer getPlayer(String var1, boolean var2, boolean var3);

    public abstract void loadOnlinePlayers();
}

