/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.motd;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import me.remigio07.chatplugin.api.common.util.Utils;
import me.remigio07.chatplugin.api.common.util.ValueContainer;
import me.remigio07.chatplugin.api.common.util.packet.PacketDeserializer;
import me.remigio07.chatplugin.api.common.util.packet.PacketSerializer;
import me.remigio07.chatplugin.api.common.util.packet.Packets;
import me.remigio07.chatplugin.api.server.util.manager.ProxyManager;

public class MoTD {
    private String description;
    private String hover;
    private String versionName;
    private URL customIconURL;
    private boolean hoverDisplayed;
    private boolean versionNameDisplayed;
    private boolean customIconDisplayed;
    private ValueContainer<Integer> onlinePlayers;
    private ValueContainer<Integer> maxPlayers;

    public MoTD(String description, String hover, String versionName, URL customIconURL, boolean hoverDisplayed, boolean versionNameDisplayed, boolean customIconDisplayed, ValueContainer<Integer> onlinePlayers, ValueContainer<Integer> maxPlayers) {
        this.description = description;
        this.hover = hover;
        this.versionName = versionName;
        this.customIconURL = customIconURL;
        this.hoverDisplayed = hoverDisplayed;
        this.versionNameDisplayed = versionNameDisplayed;
        this.customIconDisplayed = customIconDisplayed;
        this.onlinePlayers = onlinePlayers;
        this.maxPlayers = maxPlayers;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHover() {
        return this.hover;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public URL getCustomIconURL() {
        return this.customIconURL;
    }

    public boolean isHoverDisplayed() {
        return this.hoverDisplayed;
    }

    public boolean isVersionNameDisplayed() {
        return this.versionNameDisplayed;
    }

    public boolean isCustomIconDisplayed() {
        return this.customIconDisplayed;
    }

    public ValueContainer<Integer> getOnlinePlayers() {
        return this.onlinePlayers;
    }

    public ValueContainer<Integer> getMaxPlayers() {
        return this.maxPlayers;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setHover(String hover) {
        this.hover = hover;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public void setCustomIconURL(URL customIconURL) {
        this.customIconURL = customIconURL;
    }

    public void setHoverDisplayed(boolean hoverDisplayed) {
        this.hoverDisplayed = hoverDisplayed;
    }

    public void setVersionNameDisplayed(boolean versionNameDisplayed) {
        this.versionNameDisplayed = versionNameDisplayed;
    }

    public void setCustomIconDisplayed(boolean customIconDisplayed) {
        this.customIconDisplayed = customIconDisplayed;
    }

    public void setOnlinePlayers(ValueContainer<Integer> onlinePlayers) {
        this.onlinePlayers = onlinePlayers;
    }

    public void setMaxPlayers(ValueContainer<Integer> maxPlayers) {
        this.maxPlayers = maxPlayers;
    }

    public PacketSerializer toPacket(InetAddress ipAddress) {
        return Packets.Sync.motdResponse(ProxyManager.getInstance().getServerID(), ipAddress, this.description, this.hover, this.versionName, this.customIconURL, this.hoverDisplayed, this.versionNameDisplayed, this.customIconDisplayed, this.onlinePlayers, this.maxPlayers);
    }

    public static MoTD fromPacket(byte[] packet) {
        PacketDeserializer deserializer = new PacketDeserializer(packet);
        if (deserializer.readUTF().equals("MoTDResponse")) {
            deserializer.readUTF();
            deserializer.readUTF();
            try {
                String tmp = deserializer.readUTF();
                ValueContainer<Integer> valueContainer = new ValueContainer<Integer>(Utils.isInteger(tmp) ? Integer.valueOf(tmp) : tmp);
                tmp = deserializer.readUTF();
                return new MoTD(deserializer.readUTF(), deserializer.readUTF(), deserializer.readUTF(), new URI(deserializer.readUTF()).toURL(), deserializer.readBoolean(), deserializer.readBoolean(), deserializer.readBoolean(), valueContainer, new ValueContainer<Integer>(Utils.isInteger(tmp) ? Integer.valueOf(tmp) : tmp));
            }
            catch (MalformedURLException | URISyntaxException exception) {
                // empty catch block
            }
        }
        return null;
    }
}

