/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.ip_lookup;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import me.remigio07.chatplugin.api.common.ip_lookup.IPLookup;
import me.remigio07.chatplugin.api.common.util.Library;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManager;

public abstract class LocalIPLookupManager
implements ChatPluginManager {
    public static final Library[] LIBRARIES = new Library[]{Library.MAXMIND_DB_READER, Library.MAXMIND_GEOIP2, Library.APACHE_HTTPCLIENT, Library.APACHE_COMMONS_CODEC, Library.APACHE_COMMONS_LOGGING, Library.APACHE_HTTPCORE, Library.JACKSON_CORE, Library.JACKSON_ANNOTATIONS, Library.JACKSON_DATABIND, Library.ACTIVATION_FRAMEWORK, Library.ICE_TAR};
    protected static LocalIPLookupManager instance;
    protected boolean enabled;
    protected Path cityDatabase;
    protected Path asnDatabase;
    protected Path lock;
    protected long loadTime;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public Path getCityDatabase() {
        return this.cityDatabase;
    }

    public Path getASNDatabase() {
        return this.asnDatabase;
    }

    public Path getLock() {
        return this.lock;
    }

    public static LocalIPLookupManager getInstance() {
        return instance;
    }

    public abstract void update(IPLookup var1);

    public abstract void downloadDatabase(DatabaseType var1) throws IOException;

    public abstract URL formatURL(DatabaseType var1);

    public abstract Object getCityDatabaseReader();

    public abstract Object getASNDatabaseReader();

    public abstract void refreshDatabaseFile(DatabaseType var1) throws IOException;

    public static enum DatabaseType {
        ASN("ASN", "https://download.maxmind.com/app/geoip_download?edition_id=GeoLite2-ASN&license_key={0}&suffix=tar.gz"),
        CITY("city", "https://download.maxmind.com/app/geoip_download?edition_id=GeoLite2-City&license_key={0}&suffix=tar.gz");

        private String name;
        private String url;

        private DatabaseType(String name, String url) {
            this.name = name;
            this.url = url;
        }

        public String getName() {
            return this.name;
        }

        public String getURL() {
            return this.url;
        }
    }
}

