/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.ip_lookup;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import me.remigio07.chatplugin.api.common.ip_lookup.IPLookup;
import me.remigio07.chatplugin.api.common.ip_lookup.IPLookupMethod;
import me.remigio07.chatplugin.api.common.util.annotation.SensitiveData;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManager;

public abstract class IPLookupManager
implements ChatPluginManager {
    protected static IPLookupManager instance;
    protected static final String URL = "https://geolite.info/geoip/v2.1/city/{0}";
    protected boolean enabled;
    protected boolean loadOnJoin;
    protected IPLookupMethod method;
    protected long cacheTime;
    @SensitiveData(warning="MaxMind account's personal information")
    protected String maxMindUserID;
    @SensitiveData(warning="MaxMind account's personal information")
    protected String base64AuthString;
    protected int maxIPsStored;
    protected IPLookup disabledFeatureConstructor;
    protected Map<InetAddress, IPLookup> cache = new ConcurrentHashMap<InetAddress, IPLookup>();
    protected Map<InetAddress, CompletableFuture<IPLookup>> pendingFutures = new ConcurrentHashMap<InetAddress, CompletableFuture<IPLookup>>();
    protected long loadTime;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isLoadOnJoin() {
        return this.loadOnJoin;
    }

    public IPLookupMethod getMethod() {
        return this.method;
    }

    public long getCacheTime() {
        return this.cacheTime;
    }

    @SensitiveData(warning="MaxMind account's personal information")
    public String getMaxMindUserID() {
        return this.maxMindUserID;
    }

    @SensitiveData(warning="MaxMind account's personal information")
    public String getBase64AuthString() {
        return this.base64AuthString;
    }

    public int getMaxIPsStored() {
        return this.maxIPsStored;
    }

    public IPLookup getDisabledFeatureConstructor() {
        return this.disabledFeatureConstructor;
    }

    public String getURL() {
        return URL;
    }

    public Map<InetAddress, IPLookup> getCache() {
        return this.cache;
    }

    public IPLookup getFromCache(InetAddress ipAddress) {
        return this.cache.get(ipAddress);
    }

    @Deprecated
    public Map<InetAddress, CompletableFuture<IPLookup>> getPendingFutures() {
        return this.pendingFutures;
    }

    public CompletableFuture<IPLookup> getIPLookup(InetAddress ipAddress) {
        return this.getIPLookup(ipAddress, null);
    }

    public static IPLookupManager getInstance() {
        return instance;
    }

    public abstract CompletableFuture<IPLookup> getIPLookup(InetAddress var1, String var2);

    public abstract void putInCache(InetAddress var1, IPLookup var2);

    public abstract void removeFromCache(InetAddress var1);

    public abstract String readURL(String var1) throws URISyntaxException, IOException;
}

