/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.integration;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.remigio07.chatplugin.api.common.integration.ChatPluginIntegration;
import me.remigio07.chatplugin.api.common.integration.IntegrationManager;
import me.remigio07.chatplugin.api.common.integration.multiplatform.MultiPlatformIntegration;
import me.remigio07.chatplugin.api.common.integration.permission.PermissionIntegration;
import me.remigio07.chatplugin.api.common.integration.version.VersionIntegration;
import me.remigio07.chatplugin.api.common.util.PseudoEnum;
import me.remigio07.chatplugin.api.server.integration.anticheat.AnticheatIntegration;
import me.remigio07.chatplugin.api.server.integration.combatlog.CombatLogIntegration;
import me.remigio07.chatplugin.api.server.integration.cosmetics.CosmeticsIntegration;
import me.remigio07.chatplugin.api.server.integration.economy.EconomyIntegration;
import me.remigio07.chatplugin.api.server.integration.placeholder.PlaceholderIntegration;
import me.remigio07.chatplugin.api.server.integration.region.RegionIntegration;
import me.remigio07.chatplugin.api.server.integration.social.SocialIntegration;
import me.remigio07.chatplugin.bootstrap.Environment;

public class IntegrationType<T extends ChatPluginIntegration>
extends PseudoEnum<IntegrationType<T>> {
    private static final Set<Environment> BUKKIT = EnumSet.of(Environment.BUKKIT);
    private static final Set<Environment> NO_SPONGE = EnumSet.of(Environment.BUKKIT, Environment.FABRIC, Environment.BUNGEECORD, Environment.VELOCITY);
    private static final Set<Environment> ALL = EnumSet.allOf(Environment.class);
    public static final IntegrationType<CombatLogIntegration> COMBATLOGX = new IntegrationType("CombatLogX", "com.github.sirblobman.combatlogx.CombatPlugin", BUKKIT);
    public static final IntegrationType<SocialIntegration> DISCORDSRV = new IntegrationType("DiscordSRV", "github.scarsz.discordsrv.DiscordSRV", BUKKIT);
    public static final IntegrationType<EconomyIntegration> ESSENTIALSX = new IntegrationType("Essentials", "com.earth2me.essentials.Essentials", BUKKIT);
    public static final IntegrationType<MultiPlatformIntegration> FLOODGATE = new IntegrationType("Floodgate", "org.geysermc.floodgate.api.FloodgateApi", NO_SPONGE);
    public static final IntegrationType<CosmeticsIntegration> GADGETSMENU = new IntegrationType("GadgetsMenu", "com.yapzhenyie.GadgetsMenu.GadgetsMenu", BUKKIT);
    public static final IntegrationType<MultiPlatformIntegration> GEYSER = new IntegrationType("Geyser", "org.geysermc.geyser.api.GeyserApi", NO_SPONGE);
    public static final IntegrationType<PermissionIntegration> LUCKPERMS = new IntegrationType("LuckPerms", "net.luckperms.api.LuckPerms", ALL);
    public static final IntegrationType<AnticheatIntegration> MATRIX = new IntegrationType("Matrix", "me.rerere.matrix.Matrix", BUKKIT);
    public static final IntegrationType<PlaceholderIntegration> MVDWPLACEHOLDERAPI = new IntegrationType("MVdWPlaceholderAPI", "be.maximvdw.placeholderapi.PlaceholderAPI", BUKKIT);
    public static final IntegrationType<AnticheatIntegration> NEGATIVITY = new IntegrationType("Negativity", "com.elikill58.negativity.universal.Version", EnumSet.of(Environment.BUKKIT, Environment.SPONGE));
    public static final IntegrationType<PlaceholderIntegration> PLACEHOLDERAPI = new IntegrationType("PlaceholderAPI", "me.clip.placeholderapi.PlaceholderAPI", BUKKIT);
    public static final IntegrationType<CosmeticsIntegration> PLAYERPARTICLES = new IntegrationType("PlayerParticles", "dev.esophose.playerparticles.PlayerParticles", BUKKIT);
    public static final IntegrationType<VersionIntegration> PROTOCOLSUPPORT = new IntegrationType("ProtocolSupport", "protocolsupport.ProtocolSupport", BUKKIT);
    public static final IntegrationType<CosmeticsIntegration> ULTRACOSMETICS = new IntegrationType("UltraCosmetics", "be.isach.ultracosmetics.UltraCosmetics", BUKKIT);
    public static final IntegrationType<EconomyIntegration> VAULT = new IntegrationType("Vault", "net.milkbowl.vault.Vault", BUKKIT);
    public static final IntegrationType<VersionIntegration> VIAVERSION = new IntegrationType("ViaVersion", "com.viaversion.viaversion.api.Via", ALL);
    public static final IntegrationType<AnticheatIntegration> VULCAN = new IntegrationType("Vulcan", "me.frep.vulcan.spigot.VulcanPlugin", BUKKIT);
    public static final IntegrationType<RegionIntegration> WORLDGUARD = new IntegrationType("WorldGuard", "com.sk89q.worldguard.WorldGuard", BUKKIT);
    private static final IntegrationType<?>[] VALUES = new IntegrationType[]{COMBATLOGX, DISCORDSRV, ESSENTIALSX, FLOODGATE, GADGETSMENU, GEYSER, LUCKPERMS, MATRIX, MVDWPLACEHOLDERAPI, NEGATIVITY, PLACEHOLDERAPI, PLAYERPARTICLES, PROTOCOLSUPPORT, ULTRACOSMETICS, VAULT, VIAVERSION, VULCAN, WORLDGUARD};
    private static int ordinal = 0;
    private String plugin;
    private String clazz;
    private Set<Environment> supportedEnvironments;

    private IntegrationType(String plugin, String clazz, Set<Environment> supportedEnvironments) {
        super(plugin.toUpperCase(), ordinal++);
        this.plugin = plugin;
        this.clazz = clazz;
        this.supportedEnvironments = supportedEnvironments;
    }

    public T get() {
        return IntegrationManager.getInstance().getIntegration(this);
    }

    public String getPlugin() {
        return this.plugin;
    }

    public String getClazz() {
        return this.clazz;
    }

    public Set<Environment> getSupportedEnvironments() {
        return this.supportedEnvironments;
    }

    public boolean isEnabled() {
        T integration = this.get();
        return integration != null && integration.isEnabled();
    }

    public static IntegrationType<?> valueOf(String name) {
        return (IntegrationType)IntegrationType.valueOf((String)name, (PseudoEnum[])VALUES);
    }

    public static IntegrationType<?>[] values() {
        return VALUES;
    }

    public static List<IntegrationType<?>> getSupportedIntegrations() {
        return Stream.of(IntegrationType.values()).filter(type -> type.getSupportedEnvironments().contains((Object)Environment.getCurrent())).collect(Collectors.toList());
    }
}

