/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.common.integration;

import java.util.HashMap;
import java.util.Map;
import me.remigio07.chatplugin.api.common.integration.ChatPluginIntegration;
import me.remigio07.chatplugin.api.common.integration.IntegrationType;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManager;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManagerException;

public abstract class IntegrationManager
implements ChatPluginManager {
    protected static IntegrationManager instance;
    protected boolean enabled;
    protected Map<IntegrationType<? extends ChatPluginIntegration>, ChatPluginIntegration> integrations = new HashMap<IntegrationType<? extends ChatPluginIntegration>, ChatPluginIntegration>();
    protected long loadTime;

    @Override
    public void unload() throws ChatPluginManagerException {
        this.enabled = false;
        this.integrations.clear();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isReloadable() {
        return false;
    }

    public Map<IntegrationType<?>, ChatPluginIntegration> getIntegrations() {
        return this.integrations;
    }

    public <T extends ChatPluginIntegration> T getIntegration(IntegrationType<T> type) {
        return (T)this.integrations.get(type);
    }

    protected void putIntegration(ChatPluginIntegration integration) {
        this.integrations.put(integration.getType(), integration);
    }

    public boolean isAtLeastOneAnticheatEnabled() {
        return this.enabled && (IntegrationType.MATRIX.isEnabled() || IntegrationType.VULCAN.isEnabled() || IntegrationType.NEGATIVITY.isEnabled());
    }

    public static IntegrationManager getInstance() {
        return instance;
    }
}

