/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.bootstrap;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import java.nio.file.Path;
import me.remigio07.chatplugin.bootstrap.Environment;
import me.remigio07.chatplugin.bootstrap.JARLibraryLoader;
import org.slf4j.Logger;

@Plugin(id="chatplugin", name="ChatPlugin", version="1.10.5", url="https://remigio07.me/chatplugin", description="A feature-rich and modular chat ecosystem, lightweight and efficient by design.", authors={"Remigio07"}, dependencies={@Dependency(id="ViaVersion", optional=true), @Dependency(id="Geyser-Velocity", optional=true)})
public class VelocityBootstrapper {
    private static VelocityBootstrapper instance;
    private ProxyServer proxy;
    private Logger logger;
    private Path dataFolder;

    @Inject
    public VelocityBootstrapper(ProxyServer proxy, Logger logger, @DataDirectory Path dataFolder) {
        instance = this;
        this.proxy = proxy;
        this.logger = logger;
        this.dataFolder = dataFolder;
    }

    @Subscribe
    public void onProxyInitialize(ProxyInitializeEvent event) {
        Environment.currentEnvironment = Environment.VELOCITY;
        JARLibraryLoader.getInstance().open(Environment.currentEnvironment, this.logger, this.dataFolder, this.proxy);
    }

    public ProxyServer getProxy() {
        return this.proxy;
    }

    public static VelocityBootstrapper getInstance() {
        return instance;
    }
}

