/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.bootstrap;

import com.google.inject.Inject;
import java.io.IOException;
import java.nio.file.Path;
import me.remigio07.chatplugin.api.ChatPlugin;
import me.remigio07.chatplugin.bootstrap.Environment;
import me.remigio07.chatplugin.bootstrap.IsolatedClassLoader;
import me.remigio07.chatplugin.bootstrap.JARLibraryLoader;
import org.slf4j.Logger;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.event.game.state.GameStoppedServerEvent;
import org.spongepowered.api.plugin.Dependency;
import org.spongepowered.api.plugin.Plugin;

@Plugin(id="chatplugin", name="ChatPlugin", version="1.10.5", url="https://remigio07.me/chatplugin", description="A feature-rich and modular chat ecosystem, lightweight and efficient by design.", authors={"Remigio07"}, dependencies={@Dependency(id="negativity", version="[1.9.0,)", optional=true), @Dependency(id="viaversion", version="[4.0.0,)", optional=true)})
public class SpongeBootstrapper {
    private static SpongeBootstrapper instance;
    @Inject
    private Logger logger;
    @Inject
    @ConfigDir(sharedRoot=false)
    private Path dataFolder;

    @Listener
    public void onGameStartedServer(GameStartedServerEvent event) {
        instance = this;
        Environment.currentEnvironment = Environment.SPONGE;
        JARLibraryLoader.getInstance().open(Environment.currentEnvironment, this.logger, this.dataFolder, null);
    }

    @Listener
    public void onGameStoppedServer(GameStoppedServerEvent event) {
        ChatPlugin.getInstance().unload();
        try {
            JARLibraryLoader.getInstance().close();
            IsolatedClassLoader.getInstance().close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static SpongeBootstrapper getInstance() {
        return instance;
    }
}

