/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.bootstrap;

import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import me.remigio07.chatplugin.bootstrap.Environment;
import me.remigio07.chatplugin.bootstrap.JARLibraryLoader;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.server.MinecraftServer;

public class FabricBootstrapper
implements DedicatedServerModInitializer {
    private static FabricBootstrapper instance;
    private MinecraftServer server;

    public void onInitializeServer() {
        instance = this;
        Logger logger = Logger.getLogger("ChatPlugin");
        ConsoleHandler handler = new ConsoleHandler();
        ImmutableMap logLevels = ImmutableMap.of((Object)Level.INFO, (Object)"INFO", (Object)Level.WARNING, (Object)"WARN", (Object)Level.SEVERE, (Object)"ERROR");
        handler.setFormatter(new Formatter((Map)logLevels){
            final /* synthetic */ Map val$logLevels;
            {
                this.val$logLevels = map;
            }

            @Override
            public String format(LogRecord record) {
                return String.format("[%1$tT %2$s]: [ChatPlugin] %3$s%n", new Date(record.getMillis()), this.val$logLevels.get(record.getLevel()), record.getMessage());
            }
        });
        logger.setUseParentHandlers(false);
        logger.addHandler(handler);
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            Environment.currentEnvironment = Environment.FABRIC;
            Object[] objectArray = new Object[3];
            objectArray[0] = logger;
            objectArray[1] = FabricLoader.getInstance().getConfigDir().resolve("chatplugin");
            this.server = server;
            objectArray[2] = this.server;
            JARLibraryLoader.getInstance().open(Environment.currentEnvironment, objectArray);
        });
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public static FabricBootstrapper getInstance() {
        return instance;
    }
}

