/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.util.socket;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.StringJoiner;
import me.remigio07.chatplugin.api.common.util.manager.LogManager;
import me.remigio07.chatplugin.api.common.util.packet.PacketDeserializer;
import me.remigio07.chatplugin.api.common.util.packet.PacketSerializer;
import me.remigio07.chatplugin.api.server.event.socket.ClientConnectionEvent;
import me.remigio07.chatplugin.api.server.event.socket.ClientDisconnectionEvent;
import me.remigio07.chatplugin.api.server.event.socket.ClientReceivePacketEvent;
import me.remigio07.chatplugin.api.server.util.socket.ConnectionOutcome;

public class Client {
    private InetAddress serverAddress;
    private int serverPort;
    private Socket socket;
    private String id;
    private String disconnectionReason;
    private DataInputStream input;
    private DataOutputStream output;
    private ConnectionOutcome temp;

    public Client(InetAddress serverAddress, int serverPort) {
        if (serverPort < 0 || serverPort > 65535) {
            throw new IllegalArgumentException("Port value out of range: " + serverPort);
        }
        this.serverAddress = serverAddress;
        this.serverPort = serverPort;
    }

    public String toString() {
        return new StringJoiner(", ", "Client{", "}").add("serverAddress=" + this.serverAddress.getHostAddress()).add("serverPort=" + this.serverPort).add("id=" + (this.id == null ? this.id : "\"" + this.id + "\"")).toString();
    }

    public ConnectionOutcome connect(String id) throws IOException, InterruptedException {
        if (this.isConnected()) {
            return ConnectionOutcome.ALREADY_CONNECTED;
        }
        Socket socket = new Socket(this.serverAddress, this.serverPort);
        DataInputStream tempInput = new DataInputStream(socket.getInputStream());
        DataOutputStream tempOutput = new DataOutputStream(socket.getOutputStream());
        tempOutput.writeUTF(id);
        LogManager.log("[SOCKETS] Connection accepted for client \"{0}\"; waiting for the server to validate the ID...", 4, id);
        new Thread(() -> {
            try {
                this.temp = ConnectionOutcome.valueOf(tempInput.readUTF());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }).start();
        for (int i = 0; i < 49; ++i) {
            if (this.temp == null) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException ie) {
                    LogManager.log("[SOCKETS] The identification task for client \"{0}\" has been suddenly interrupted: {1}", 2, id, ie.getLocalizedMessage());
                    socket.close();
                    tempInput.close();
                    tempOutput.close();
                    throw ie;
                }
            }
            if (this.temp == ConnectionOutcome.SUCCESS) {
                this.socket = socket;
                this.id = id;
                this.input = tempInput;
                this.output = tempOutput;
                new Thread(() -> this.run()).start();
                new ClientConnectionEvent(this).call();
                LogManager.log("[SOCKETS] Client \"{0}\" has just connected to the server using address {1}.", 4, id, socket.getInetAddress().getHostAddress() + ":" + socket.getLocalPort());
            } else {
                socket.close();
                tempInput.close();
                tempOutput.close();
                LogManager.log("[SOCKETS] Client \"{0}\" has just tried to connect but the {1}.", 2, id, this.temp.getMessage());
            }
            ConnectionOutcome temp2 = this.temp;
            this.temp = null;
            return temp2;
        }
        socket.close();
        tempInput.close();
        tempOutput.close();
        LogManager.log("[SOCKETS] Client \"{0}\" did not receive a response within 5000 ms so it was disconnected.", 4, id);
        return ConnectionOutcome.TIMEOUT;
    }

    public void disconnect() throws IOException {
        if (!this.isConnected()) {
            return;
        }
        this.output.writeShort(-1);
        this.socket.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void run() {
        try {
            DataInputStream dataInputStream = this.input;
            synchronized (dataInputStream) {
                short bytesRead;
                while ((bytesRead = this.input.readShort()) != -1) {
                    byte[] data = new byte[bytesRead];
                    this.input.readFully(data);
                    new ClientReceivePacketEvent(this, data).call();
                    PacketDeserializer packet = new PacketDeserializer(data);
                    if (!packet.readUTF().equals("ClientDisconnection")) continue;
                    this.disconnectionReason = packet.readUTF();
                }
            }
        }
        catch (EOFException | SocketException iOException) {
        }
        catch (IOException ioe) {
            LogManager.log("[SOCKETS] IOException occurred while reading a packet for client \"{0}\": {1}", 2, this.id, ioe.getLocalizedMessage());
        }
        try {
            this.socket.close();
        }
        catch (IOException ioe) {
            LogManager.log("[SOCKETS] IOException occurred while closing socket for client \"{0}\": {1}", 2, this.id, ioe.getLocalizedMessage());
        }
        new ClientDisconnectionEvent(this).call();
        LogManager.log("[SOCKETS] Client \"{0}\" has just disconnected from the server{1}", 4, this.id, this.disconnectionReason == null ? "." : ": " + this.disconnectionReason);
        this.socket = null;
        this.id = null;
        this.input = null;
        this.output = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket(PacketSerializer packet) {
        if (!this.isConnected()) {
            return;
        }
        byte[] data = packet.toArray();
        try {
            DataOutputStream dataOutputStream = this.output;
            synchronized (dataOutputStream) {
                this.output.writeShort(data.length);
                this.output.write(data);
            }
        }
        catch (IOException ioe) {
            LogManager.log("[SOCKETS] IOException occurred while writing a packet for client \"{0}\": {1}", 2, this.id, ioe.getLocalizedMessage());
        }
    }

    public InetAddress getServerAddress() {
        return this.serverAddress;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public String getID() {
        return this.id;
    }

    public DataInputStream getInput() {
        return this.input;
    }

    public DataOutputStream getOutput() {
        return this.output;
    }

    public boolean isConnected() {
        return this.socket != null;
    }
}

