/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.util.manager;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.remigio07.chatplugin.api.common.chat.DenyChatReasonHandler;
import me.remigio07.chatplugin.api.common.util.VersionUtils;
import me.remigio07.chatplugin.api.server.player.ChatPluginServerPlayer;
import me.remigio07.chatplugin.api.server.util.GameFeature;

@GameFeature(name="vanish", minimumFabricVersion=VersionUtils.Version.UNSUPPORTED)
public abstract class VanishManager
implements DenyChatReasonHandler {
    public static final String VANISH_PERMISSION = "chatplugin.commands.vanish";
    protected static VanishManager instance;
    protected boolean enabled;
    protected boolean invisibility;
    protected Map<String, List<ChatPluginServerPlayer>> vanished = new ConcurrentHashMap<String, List<ChatPluginServerPlayer>>();
    protected long loadTime;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isInvisibility() {
        return this.invisibility;
    }

    public Map<String, List<ChatPluginServerPlayer>> getVanishedMap() {
        return this.vanished;
    }

    public List<ChatPluginServerPlayer> getVanishedList(String world) {
        return this.vanished.getOrDefault(world, Collections.emptyList());
    }

    public int getVanishedAmount() {
        return this.getVanishedList().size();
    }

    public static VanishManager getInstance() {
        return instance;
    }

    public abstract void hide(ChatPluginServerPlayer var1);

    public abstract void show(ChatPluginServerPlayer var1);

    public abstract List<ChatPluginServerPlayer> getVanishedList();

    public abstract List<String> getVanishedNames();

    public abstract boolean isVanished(ChatPluginServerPlayer var1);

    public abstract int getOnlineWorld(String var1);

    public abstract int getOnlineServer();
}

