/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.util.manager;

import java.util.List;
import java.util.StringJoiner;
import java.util.concurrent.CopyOnWriteArrayList;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManager;
import me.remigio07.chatplugin.api.server.language.Language;
import me.remigio07.chatplugin.api.server.util.GameFeature;

@GameFeature(name="TPS", spigotRequired=true)
public abstract class TPSManager
implements ChatPluginManager,
Runnable {
    public static final String[] PLACEHOLDERS = new String[]{"tps_1_min", "tps_5_min", "tps_15_min", "tps_1_min_format", "tps_5_min_format", "tps_15_min_format"};
    protected static TPSManager instance;
    protected boolean enabled;
    protected boolean tpsCapEnabled;
    protected List<TPSQuality> qualities = new CopyOnWriteArrayList<TPSQuality>();
    protected double[] recentTPS = new double[]{20.0, 20.0, 20.0};
    protected long updateTimeout;
    protected long timerTaskID = -1L;
    protected long loadTime;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isTPSCapEnabled() {
        return this.tpsCapEnabled;
    }

    public List<TPSQuality> getQualities() {
        return this.qualities;
    }

    public double[] getRecentTPS() {
        return this.recentTPS;
    }

    public long getUpdateTimeout() {
        return this.updateTimeout;
    }

    public long getTimerTaskID() {
        return this.timerTaskID;
    }

    public static TPSManager getInstance() {
        return instance;
    }

    @Override
    public abstract void run();

    public abstract double getTPS(TPSTimeInterval var1);

    public abstract TPSQuality getTPSQuality(double var1);

    public abstract String formatTPS(double var1, Language var3);

    public abstract String formatTPS(TPSTimeInterval var1, Language var2);

    public abstract String formatPlaceholders(String var1, Language var2);

    public abstract List<String> formatPlaceholders(List<String> var1, Language var2);

    public static enum TPSTimeInterval {
        ONE_MINUTE,
        FIVE_MINUTES,
        FIFTEEN_MINUTES;

    }

    public class TPSQuality
    implements Comparable<TPSQuality> {
        private String id;
        private double minimumTPS;

        public TPSQuality(String id, double minimumTPS) {
            if (minimumTPS < 0.0) {
                throw new IllegalArgumentException("Specified minimum TPS is less than 0");
            }
            this.id = id;
            this.minimumTPS = minimumTPS;
        }

        @Override
        public int compareTo(TPSQuality o) {
            return this.minimumTPS < o.getMinimumTPS() ? -1 : (this.minimumTPS == o.getMinimumTPS() ? 0 : 1);
        }

        public String toString() {
            return new StringJoiner(", ", "TPSQuality{", "}").add("id=\"" + this.id + "\"").add("minimumTPS=" + this.minimumTPS).toString();
        }

        public String getID() {
            return this.id;
        }

        public double getMinimumTPS() {
            return this.minimumTPS;
        }

        public String getColor(Language language) {
            return language.getMessage("tps-qualities." + this.id, new Object[0]);
        }
    }
}

