/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.util.adapter.scoreboard;

import me.remigio07.chatplugin.api.server.util.Utils;
import me.remigio07.chatplugin.bootstrap.Environment;
import net.minecraft.class_266;
import org.spongepowered.api.scoreboard.objective.Objective;

public class ObjectiveAdapter {
    private Object objective;

    public ObjectiveAdapter(Object objective) {
        this.objective = objective;
    }

    public org.bukkit.scoreboard.Objective bukkitValue() {
        if (Environment.isBukkit()) {
            return (org.bukkit.scoreboard.Objective)this.objective;
        }
        throw new UnsupportedOperationException("Unable to adapt objective to a Bukkit's Objective on a " + Environment.getCurrent().getName() + " environment");
    }

    public Objective spongeValue() {
        if (Environment.isSponge()) {
            return (Objective)this.objective;
        }
        throw new UnsupportedOperationException("Unable to adapt objective to a Sponge's Objective on a " + Environment.getCurrent().getName() + " environment");
    }

    public class_266 fabricValue() {
        if (Environment.isFabric()) {
            return (class_266)this.objective;
        }
        throw new UnsupportedOperationException("Unable to adapt objective to a Fabric's ScoreboardObjective on a " + Environment.getCurrent().getName() + " environment");
    }

    public String getDisplayName() {
        return Environment.isBukkit() ? this.bukkitValue().getDisplayName() : (Environment.isSponge() ? Utils.toLegacyText(this.spongeValue().getDisplayName()) : Utils.toLegacyText(this.fabricValue().method_1114()));
    }

    public ObjectiveAdapter setDisplayName(String displayName) {
        if (Environment.isBukkit()) {
            this.bukkitValue().setDisplayName(displayName);
        } else if (Environment.isSponge()) {
            this.spongeValue().setDisplayName(Utils.toSpongeComponent(displayName));
        } else {
            this.fabricValue().method_1121(Utils.toFabricComponent(displayName));
        }
        return this;
    }
}

