/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.util.adapter.inventory.item;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.awt.Color;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.remigio07.chatplugin.api.common.player.PlayerManager;
import me.remigio07.chatplugin.api.common.util.UUIDFetcher;
import me.remigio07.chatplugin.api.common.util.VersionUtils;
import me.remigio07.chatplugin.api.common.util.manager.LogManager;
import me.remigio07.chatplugin.api.common.util.manager.TaskManager;
import me.remigio07.chatplugin.api.server.util.Utils;
import me.remigio07.chatplugin.api.server.util.adapter.block.MaterialAdapter;
import me.remigio07.chatplugin.api.server.util.adapter.inventory.item.EnchantmentAdapter;
import me.remigio07.chatplugin.api.server.util.adapter.inventory.item.ItemFlagAdapter;
import me.remigio07.chatplugin.bootstrap.Environment;
import me.remigio07.chatplugin.bootstrap.FabricBootstrapper;
import me.remigio07.chatplugin.bootstrap.JARLibraryLoader;
import net.minecraft.class_10712;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3902;
import net.minecraft.class_5250;
import net.minecraft.class_6538;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_9282;
import net.minecraft.class_9285;
import net.minecraft.class_9290;
import net.minecraft.class_9296;
import net.minecraft.class_9304;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9792;
import org.bukkit.Bukkit;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.mutable.DisplayNameData;
import org.spongepowered.api.data.manipulator.mutable.DyeableData;
import org.spongepowered.api.data.manipulator.mutable.RepresentedPlayerData;
import org.spongepowered.api.data.manipulator.mutable.item.DurabilityData;
import org.spongepowered.api.data.manipulator.mutable.item.EnchantmentData;
import org.spongepowered.api.data.manipulator.mutable.item.LoreData;
import org.spongepowered.api.data.property.item.UseLimitProperty;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.enchantment.Enchantment;
import org.spongepowered.api.item.enchantment.EnchantmentType;
import org.spongepowered.api.profile.property.ProfileProperty;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.translation.FixedTranslation;
import org.spongepowered.api.text.translation.Translation;

public class ItemStackAdapter
implements Cloneable {
    private Object itemStack;
    private MaterialAdapter type;
    private List<ItemFlagAdapter> itemFlags = new CopyOnWriteArrayList<ItemFlagAdapter>();
    private Map<EnchantmentAdapter, Integer> enchantments = new ConcurrentHashMap<EnchantmentAdapter, Integer>();
    private String skullOwner;
    private boolean itemMeta = true;
    private static Map<String, Object[]> skullsCache = new ConcurrentHashMap<String, Object[]>();
    private static List<String> nonPremiumUsernames = new CopyOnWriteArrayList<String>();

    public ItemStackAdapter(MaterialAdapter type) {
        this(type, 1);
    }

    public ItemStackAdapter(MaterialAdapter type, short amount) {
        this(type, amount, 0);
    }

    public ItemStackAdapter(MaterialAdapter type, short amount, short damage) {
        this.type = type;
        amount = amount < 0 ? 0 : (amount > 64 ? 64 : amount);
        short s = damage = damage < 0 ? (short)0 : damage;
        if (Environment.isBukkit()) {
            this.itemStack = new ItemStack(type.bukkitValue(), amount, damage);
            if (!Bukkit.getItemFactory().isApplicable(this.bukkitValue().getItemMeta(), (ItemStack)this.itemStack)) {
                this.itemMeta = false;
            }
            return;
        }
        this.itemStack = Environment.isSponge() ? org.spongepowered.api.item.inventory.ItemStack.builder().itemType(type.spongeValue()).quantity(amount).build() : FabricItemStack.newInstance(type, (short)amount);
        this.setDamage(damage);
    }

    public ItemStackAdapter(Object itemStack) {
        this.itemStack = itemStack;
        if (Environment.isBukkit()) {
            this.type = new MaterialAdapter(((ItemStack)itemStack).getType().name());
            if (((ItemStack)itemStack).hasItemMeta()) {
                ItemMeta meta = ((ItemStack)itemStack).getItemMeta();
                meta.getEnchants().forEach((enchantment, level) -> this.enchantments.put(EnchantmentAdapter.value(enchantment.getName()), (Integer)level));
                meta.getItemFlags().stream().map(itemFlag -> ItemFlagAdapter.value(itemFlag.name())).filter(Objects::nonNull).distinct().forEach(this.itemFlags::add);
                if (this.isPlayerHead()) {
                    this.skullOwner = ((SkullMeta)meta).getOwner();
                }
            } else {
                this.itemMeta = false;
            }
        } else if (Environment.isSponge()) {
            this.type = new MaterialAdapter(((org.spongepowered.api.item.inventory.ItemStack)itemStack).getType().getId().substring(10));
            for (ItemFlagAdapter itemFlag2 : ItemFlagAdapter.values()) {
                if (!((Boolean)((org.spongepowered.api.item.inventory.ItemStack)itemStack).getOrElse(itemFlag2.spongeValue(), (Object)false)).booleanValue()) continue;
                this.itemFlags.add(itemFlag2);
            }
            if (!((EnchantmentData)((org.spongepowered.api.item.inventory.ItemStack)itemStack).getOrCreate(EnchantmentData.class).get()).enchantments().isEmpty()) {
                ((List)((EnchantmentData)((org.spongepowered.api.item.inventory.ItemStack)itemStack).get(EnchantmentData.class).get()).enchantments().get()).forEach(enchantment -> this.enchantments.put(EnchantmentAdapter.value(enchantment.getType().getId().substring(10)), enchantment.getLevel()));
            }
            if (this.isPlayerHead()) {
                this.spongeValue().get(RepresentedPlayerData.class).ifPresent(player -> ((org.spongepowered.api.profile.GameProfile)player.owner().get()).getName().ifPresent(name -> {
                    this.skullOwner = name;
                }));
            }
        } else {
            try {
                class_2487 nbt;
                class_1799 fabricValue = (class_1799)itemStack;
                this.type = new MaterialAdapter(VersionUtils.getVersion().isOlderThan(VersionUtils.Version.V1_19_3) ? class_2378.class.getMethod("method_10221", Object.class).invoke(class_2378.class.getField("field_11142").get(null), fabricValue.method_7909()).toString() : class_7923.field_41178.method_10221((Object)fabricValue.method_7909()).toString());
                if (fabricValue.method_7942()) {
                    if (VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_20_5)) {
                        class_9304 enchantments = fabricValue.method_58657();
                        enchantments.method_57534().forEach(enchantment -> this.enchantments.put(EnchantmentAdapter.value(enchantment.method_55840()), enchantments.method_57536(enchantment)));
                    } else if (VersionUtils.getVersion().isOlderThan(VersionUtils.Version.V1_19_3)) {
                        Method getId = class_2378.class.getMethod("method_10221", Object.class);
                        Object ENCHANTMENT = class_2378.class.getField("field_11160").get(null);
                        for (Map.Entry enchantment2 : ((Map)class_1890.class.getMethod("method_8222", class_1799.class).invoke(null, fabricValue)).entrySet()) {
                            this.enchantments.put(EnchantmentAdapter.value(getId.invoke(ENCHANTMENT, enchantment2.getKey()).toString()), (Integer)enchantment2.getValue());
                        }
                    } else {
                        class_2378 ENCHANTMENT = (class_2378)class_7923.class.getField("field_41176").get(null);
                        ((Map)class_1890.class.getMethod("method_8222", class_1799.class).invoke(null, fabricValue)).forEach((enchantment, level) -> this.enchantments.put(EnchantmentAdapter.value(ENCHANTMENT.method_10221(enchantment).toString()), (Integer)level));
                    }
                }
                if (VersionUtils.getVersion().isOlderThan(VersionUtils.Version.V1_21_5)) {
                    if (VersionUtils.getVersion().isOlderThan(VersionUtils.Version.V1_20_5)) {
                        nbt = (class_2487)class_1799.class.getMethod("method_7969", new Class[0]).invoke((Object)fabricValue, new Object[0]);
                        if (nbt != null && (Byte)class_2487.class.getMethod("method_10540", String.class).invoke((Object)nbt, "HideFlags") == 99) {
                            int HideFlags = (Integer)class_2487.class.getMethod("method_10550", String.class).invoke((Object)nbt, "HideFlags");
                            for (ItemFlagAdapter itemFlag3 : ItemFlagAdapter.values()) {
                                if ((HideFlags & itemFlag3.bitModifierValue()) == 0) continue;
                                this.itemFlags.add(itemFlag3);
                            }
                        }
                    } else {
                        if (!FabricItemStack.New.showInTooltip(fabricValue.method_58657(), "field_49390")) {
                            this.itemFlags.add(ItemFlagAdapter.HIDE_ENCHANTMENTS);
                        }
                        if (!FabricItemStack.New.showInTooltip(FabricItemStack.New.get(fabricValue, class_9334.field_49636), "comp_2394")) {
                            this.itemFlags.add(ItemFlagAdapter.HIDE_ATTRIBUTES);
                        }
                        if (!FabricItemStack.New.showInTooltip(FabricItemStack.New.get(fabricValue, class_9334.field_49630), "comp_2417")) {
                            this.itemFlags.add(ItemFlagAdapter.HIDE_UNBREAKABLE);
                        }
                        if (!FabricItemStack.New.showInTooltip(FabricItemStack.New.get(fabricValue, class_9334.field_49635), "field_49253")) {
                            this.itemFlags.add(ItemFlagAdapter.HIDE_CAN_DESTROY);
                        }
                        if (!FabricItemStack.New.showInTooltip(FabricItemStack.New.get(fabricValue, class_9334.field_49634), "field_49253")) {
                            this.itemFlags.add(ItemFlagAdapter.HIDE_CAN_BE_PLACED_ON);
                        }
                        if (FabricItemStack.New.get(fabricValue, ItemFlagAdapter.HIDE_MISCELLANEOUS.fabricValue()) == class_3902.field_17274 || VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_21) && !FabricItemStack.New.showInTooltip(FabricItemStack.New.get(fabricValue, class_9334.field_52175), "comp_2834")) {
                            this.itemFlags.add(ItemFlagAdapter.HIDE_MISCELLANEOUS);
                        }
                        if (!FabricItemStack.New.showInTooltip(FabricItemStack.New.get(fabricValue, class_9334.field_49644), "comp_2385")) {
                            this.itemFlags.add(ItemFlagAdapter.HIDE_DYE);
                        }
                        if (!FabricItemStack.New.showInTooltip(FabricItemStack.New.get(fabricValue, class_9334.field_49607), "field_49279")) {
                            this.itemFlags.add(ItemFlagAdapter.HIDE_ARMOR_TRIM);
                        }
                    }
                } else {
                    class_10712 tooltipDisplay = (class_10712)fabricValue.method_58694(class_9334.field_56400);
                    if (tooltipDisplay != null) {
                        for (ItemFlagAdapter itemFlag4 : ItemFlagAdapter.values()) {
                            if (itemFlag4 == ItemFlagAdapter.HIDE_MISCELLANEOUS) {
                                if (!FabricItemStack.New.MISCELLANEOUS_COMPONENTS.stream().anyMatch(arg_0 -> ((class_10712)tooltipDisplay).method_67214(arg_0))) continue;
                            } else if (!tooltipDisplay.method_67214(itemFlag4.fabricValue())) continue;
                            this.itemFlags.add(itemFlag4);
                        }
                    }
                }
                if (this.isPlayerHead()) {
                    if (VersionUtils.getVersion().isOlderThan(VersionUtils.Version.V1_20_5)) {
                        nbt = (class_2487)class_1799.class.getMethod("method_7969", new Class[0]).invoke((Object)fabricValue, new Object[0]);
                        if (nbt != null) {
                            byte type = (Byte)class_2487.class.getMethod("method_10540", String.class).invoke((Object)nbt, "SkullOwner");
                            if (type == 10) {
                                class_2487 SkullOwner = (class_2487)class_2487.class.getMethod("method_10562", String.class).invoke((Object)nbt, "SkullOwner");
                                if ((Byte)class_2487.class.getMethod("method_10540", String.class).invoke((Object)SkullOwner, "Name") == 8) {
                                    this.skullOwner = (String)class_2487.class.getMethod("method_10558", String.class).invoke((Object)SkullOwner, "Name");
                                }
                            } else if (type == 8) {
                                this.skullOwner = (String)class_2487.class.getMethod("method_10558", String.class).invoke((Object)nbt, "SkullOwner");
                            }
                        }
                    } else {
                        ((class_9296)FabricItemStack.New.get(fabricValue, class_9334.field_49617)).method_73317().ifPresent(owner -> {
                            this.skullOwner = owner;
                        });
                    }
                }
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public ItemStackAdapter clone() {
        ItemStackAdapter itemStack = new ItemStackAdapter(this.type.clone(), this.getAmount(), this.getDamage());
        if (this.hasDisplayName()) {
            itemStack.setDisplayName(this.getDisplayName());
        }
        if (this.hasLore()) {
            itemStack.setLore(new ArrayList<String>(this.getLore()));
        }
        if (this.isEnchanted()) {
            this.enchantments.forEach(itemStack::enchant);
        }
        if (this.isPlayerHead()) {
            if (this.getSkullOwner() != null) {
                itemStack.setSkullOwner(this.getSkullOwner(), this.getSkullTextureURL() != null);
            } else if (this.getSkullTextureURL() != null) {
                itemStack.setSkullTextureURL(this.getSkullTextureURL());
            }
        } else if (this.isLeatherArmor()) {
            itemStack.setLeatherArmorColor(this.getLeatherArmorColor());
        }
        itemStack.addItemFlags(this.itemFlags.toArray(new ItemFlagAdapter[this.itemFlags.size()]));
        return itemStack;
    }

    public ItemStack bukkitValue() {
        if (Environment.isBukkit()) {
            return (ItemStack)this.itemStack;
        }
        throw new UnsupportedOperationException("Unable to adapt item stack to a Bukkit's ItemStack on a " + Environment.getCurrent().getName() + " environment");
    }

    public org.spongepowered.api.item.inventory.ItemStack spongeValue() {
        if (Environment.isSponge()) {
            return (org.spongepowered.api.item.inventory.ItemStack)this.itemStack;
        }
        throw new UnsupportedOperationException("Unable to adapt item stack to a Sponge's ItemStack on a " + Environment.getCurrent().getName() + " environment");
    }

    public class_1799 fabricValue() {
        if (Environment.isFabric()) {
            return (class_1799)this.itemStack;
        }
        throw new UnsupportedOperationException("Unable to adapt item stack to a Fabric's ItemStack on a " + Environment.getCurrent().getName() + " environment");
    }

    public MaterialAdapter getType() {
        return this.type;
    }

    public boolean hasItemMeta() {
        return this.itemMeta;
    }

    public short getAmount() {
        return (short)(Environment.isBukkit() ? this.bukkitValue().getAmount() : (Environment.isSponge() ? this.spongeValue().getQuantity() : this.fabricValue().method_7947()));
    }

    public ItemStackAdapter setAmount(short amount) {
        if (Environment.isBukkit()) {
            this.bukkitValue().setAmount((int)amount);
        } else if (Environment.isSponge()) {
            this.spongeValue().setQuantity((int)amount);
        } else {
            this.fabricValue().method_7939((int)amount);
        }
        return this;
    }

    public short getMaxDurability() {
        return Environment.isBukkit() ? this.type.bukkitValue().getMaxDurability() : (Environment.isSponge() ? (this.spongeValue().getProperty(UseLimitProperty.class).isPresent() ? ((Integer)((UseLimitProperty)this.spongeValue().getProperty(UseLimitProperty.class).get()).getValue()).shortValue() : (short)0) : (short)this.fabricValue().method_7936());
    }

    public short getDurability() {
        return Environment.isSponge() ? this.spongeValue().get(Keys.ITEM_DURABILITY).orElse(0).shortValue() : (short)(this.getMaxDurability() - this.getDurability());
    }

    public ItemStackAdapter setDurability(short durability) {
        if (!Environment.isSponge()) {
            this.setDamage((short)(this.getMaxDurability() - durability));
        } else if (this.spongeValue().supports(DurabilityData.class)) {
            this.spongeValue().offer(Keys.ITEM_DURABILITY, (Object)durability);
        }
        return this;
    }

    public short getDamage() {
        return (short)(Environment.isBukkit() ? this.bukkitValue().getDurability() : (Environment.isSponge() ? (this.spongeValue().supports(DurabilityData.class) ? this.getMaxDurability() - this.getDurability() : (int)SpongeItemStack.getDamage(this.spongeValue())) : this.fabricValue().method_7919()));
    }

    public ItemStackAdapter setDamage(short damage) {
        if (Environment.isBukkit()) {
            this.bukkitValue().setDurability(damage);
        } else if (Environment.isSponge()) {
            if (this.spongeValue().supports(DurabilityData.class)) {
                this.setDurability((short)(this.getMaxDurability() - damage));
            } else {
                this.itemStack = SpongeItemStack.setDamage(this.spongeValue(), damage);
            }
        } else {
            this.fabricValue().method_7974((int)damage);
        }
        return this;
    }

    public Map<EnchantmentAdapter, Integer> getEnchantments() {
        return this.enchantments;
    }

    public ItemStackAdapter enchant(EnchantmentAdapter enchantment, int level) {
        if (Environment.isBukkit()) {
            if (this.hasItemMeta()) {
                this.bukkitValue().addUnsafeEnchantment(enchantment.bukkitValue(), level);
            }
        } else if (Environment.isSponge()) {
            SpongeItemStack.enchant(this.spongeValue(), enchantment.spongeValue(), level);
        } else if (VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_21)) {
            this.fabricValue().method_7978(FabricBootstrapper.getInstance().getServer().method_30611().method_30530(class_7924.field_41265).method_47983((Object)enchantment.fabricValue()), level);
        } else {
            try {
                class_1799.class.getMethod("method_7978", class_1887.class, Integer.TYPE).invoke((Object)this.fabricValue(), enchantment.fabricValue(), level);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        this.enchantments.put(enchantment, level);
        return this;
    }

    public ItemStackAdapter enchant(Map<EnchantmentAdapter, Integer> enchantments) {
        enchantments.forEach(this::enchant);
        return this;
    }

    public ItemStackAdapter disenchant(EnchantmentAdapter enchantment) {
        if (Environment.isBukkit()) {
            this.bukkitValue().removeEnchantment(enchantment.bukkitValue());
        } else if (Environment.isSponge()) {
            SpongeItemStack.disenchant(this.spongeValue(), enchantment.spongeValue());
        } else if (VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_20_5)) {
            this.fabricValue().method_58657().method_57534().removeIf(entry -> ((class_1887)entry.comp_349()).equals((Object)enchantment.fabricValue()));
        } else {
            try {
                Map enchantments = (Map)class_1890.class.getMethod("method_8222", class_1799.class).invoke(null, this.fabricValue());
                if (enchantments.remove(enchantment.fabricValue()) == null) {
                    return this;
                }
                class_1890.class.getMethod("method_8214", Map.class, class_1799.class).invoke(null, enchantments, this.fabricValue());
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        this.enchantments.remove(enchantment);
        return this;
    }

    public ItemStackAdapter disenchant() {
        this.enchantments.keySet().forEach(this::disenchant);
        return this;
    }

    public boolean isEnchanted() {
        return !this.enchantments.isEmpty();
    }

    public ItemStackAdapter setGlowing() {
        return this.setGlowing(true);
    }

    public ItemStackAdapter setGlowing(boolean glowing) {
        if (glowing) {
            this.enchant(EnchantmentAdapter.UNBREAKING, 1);
            this.addItemFlags(ItemFlagAdapter.HIDE_ENCHANTMENTS);
        } else {
            this.disenchant();
            this.removeItemFlags(ItemFlagAdapter.HIDE_ENCHANTMENTS);
        }
        return this;
    }

    public boolean isGlowing() {
        return this.isEnchanted() && this.itemFlags.contains(ItemFlagAdapter.HIDE_ENCHANTMENTS);
    }

    public String getDisplayName() {
        if (this.hasDisplayName()) {
            if (Environment.isBukkit()) {
                return this.bukkitValue().getItemMeta().getDisplayName();
            }
            if (Environment.isSponge()) {
                return Utils.toLegacyText((Text)((DisplayNameData)this.spongeValue().get(DisplayNameData.class).get()).displayName().get());
            }
            if (Environment.isFabric()) {
                if (VersionUtils.getVersion().isOlderThan(VersionUtils.Version.V1_20_5)) {
                    try {
                        return (String)Class.forName("me.remigio07.chatplugin.common.util.Utils", false, JARLibraryLoader.getInstance()).getMethod("toLegacyText", String.class).invoke(null, new JsonParser().parse((String)class_2487.class.getMethod("method_10558", String.class).invoke(class_1799.class.getMethod("method_7911", String.class).invoke((Object)this.fabricValue(), "display"), "Name")));
                    }
                    catch (JsonSyntaxException | ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                } else {
                    return Utils.toLegacyText(this.fabricValue().method_65130());
                }
            }
        }
        return null;
    }

    public boolean hasDisplayName() {
        try {
            return Environment.isBukkit() ? (this.itemMeta ? this.bukkitValue().getItemMeta().hasDisplayName() : false) : (Environment.isSponge() ? this.spongeValue().getValue(Keys.DISPLAY_NAME).isPresent() : (VersionUtils.getVersion().isOlderThan(VersionUtils.Version.V1_20_5) ? (Boolean)class_1799.class.getMethod("method_7938", new Class[0]).invoke((Object)this.fabricValue(), new Object[0]) : this.fabricValue().method_65130() != null));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    public ItemStackAdapter setDisplayName(String displayName) {
        if (Environment.isSponge()) {
            if (displayName == null) {
                this.spongeValue().remove(Keys.DISPLAY_NAME);
            } else {
                this.spongeValue().offer(Keys.DISPLAY_NAME, (Object)Utils.toSpongeComponent(displayName));
            }
        } else if (Environment.isFabric()) {
            FabricItemStack.setDisplayName(this.fabricValue(), displayName);
        } else if (this.itemMeta) {
            ItemMeta meta = this.bukkitValue().getItemMeta();
            meta.setDisplayName(displayName);
            this.bukkitValue().setItemMeta(meta);
        }
        return this;
    }

    public List<String> getLore() {
        if (this.hasLore()) {
            if (Environment.isBukkit()) {
                return this.itemMeta ? this.bukkitValue().getItemMeta().getLore() : null;
            }
            if (Environment.isSponge()) {
                return SpongeItemStack.toStringList((List)((LoreData)this.spongeValue().getOrCreate(LoreData.class).get()).lore().get());
            }
            if (Environment.isFabric()) {
                return FabricItemStack.getLore(this.fabricValue());
            }
        }
        return null;
    }

    public boolean hasLore() {
        if (Environment.isBukkit()) {
            return this.itemMeta && this.bukkitValue().getItemMeta().hasLore();
        }
        if (Environment.isSponge()) {
            return this.spongeValue().getValue(Keys.ITEM_LORE).isPresent();
        }
        try {
            return VersionUtils.getVersion().isOlderThan(VersionUtils.Version.V1_20_5) ? (Byte)class_2487.class.getMethod("method_10540", String.class).invoke(class_1799.class.getMethod("method_7911", String.class).invoke((Object)this.fabricValue(), "display"), "Lore") == 9 : FabricItemStack.New.get(this.fabricValue(), class_9334.field_49632) != null;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    public ItemStackAdapter setLore(List<String> lore) {
        if (Environment.isSponge()) {
            if (lore == null) {
                this.spongeValue().remove(Keys.ITEM_LORE);
            } else {
                this.spongeValue().offer(Keys.ITEM_LORE, SpongeItemStack.toTextList(lore));
            }
        } else if (Environment.isFabric()) {
            FabricItemStack.setLore(this.fabricValue(), lore);
        } else if (this.itemMeta) {
            ItemMeta meta = this.bukkitValue().getItemMeta();
            meta.setLore(lore == null ? null : lore.stream().map(line -> line.replace("\n", " ").replace("\r\n", " ").replace("\r", " ")).collect(Collectors.toList()));
            this.bukkitValue().setItemMeta(meta);
        }
        return this;
    }

    public List<ItemFlagAdapter> getItemFlags() {
        return this.itemFlags;
    }

    public boolean hasItemFlag(ItemFlagAdapter itemFlag) {
        return this.itemFlags.contains(itemFlag);
    }

    public ItemStackAdapter addItemFlags(ItemFlagAdapter ... itemFlags) {
        for (ItemFlagAdapter itemFlag : itemFlags) {
            if (!itemFlag.isSupported()) {
                itemFlag = ItemFlagAdapter.HIDE_ATTRIBUTES;
            }
            if (this.itemFlags.contains(itemFlag)) continue;
            if (Environment.isSponge()) {
                this.spongeValue().offer(itemFlag.spongeValue(), (Object)true);
            } else if (Environment.isFabric()) {
                if (VersionUtils.getVersion().isOlderThan(VersionUtils.Version.V1_20_5)) {
                    try {
                        class_2487 nbt = (class_2487)class_1799.class.getMethod("method_7948", new Class[0]).invoke((Object)this.fabricValue(), new Object[0]);
                        nbt.method_10569("HideFlags", (Integer)class_2487.class.getMethod("method_10550", String.class).invoke((Object)nbt, "HideFlags") | itemFlag.bitModifierValue());
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                } else {
                    FabricItemStack.New.addItemFlag(this.fabricValue(), itemFlag);
                }
            } else if (this.itemMeta) {
                ItemMeta meta = this.bukkitValue().getItemMeta();
                if (itemFlag == ItemFlagAdapter.HIDE_ATTRIBUTES && VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_20_5)) {
                    meta.setAttributeModifiers(this.bukkitValue().getType().getDefaultAttributeModifiers(EquipmentSlot.HAND));
                }
                meta.addItemFlags(new ItemFlag[]{itemFlag.bukkitValue()});
                this.bukkitValue().setItemMeta(meta);
            }
            this.itemFlags.add(itemFlag);
        }
        return this;
    }

    public ItemStackAdapter removeItemFlags(ItemFlagAdapter ... itemFlags) {
        for (ItemFlagAdapter itemFlag : itemFlags) {
            if (!this.itemFlags.contains(itemFlag)) continue;
            if (Environment.isSponge()) {
                this.spongeValue().remove(itemFlag.spongeValue());
            } else if (Environment.isFabric()) {
                if (VersionUtils.getVersion().isOlderThan(VersionUtils.Version.V1_20_5)) {
                    try {
                        class_2487 nbt = (class_2487)class_1799.class.getMethod("method_7969", new Class[0]).invoke((Object)this.fabricValue(), new Object[0]);
                        if (nbt != null && (Byte)class_2487.class.getMethod("method_10540", String.class).invoke((Object)nbt, "HideFlags") == 99) {
                            nbt.method_10569("HideFlags", (Integer)class_2487.class.getMethod("method_10550", String.class).invoke((Object)nbt, "HideFlags") & ~itemFlag.bitModifierValue());
                        }
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                } else {
                    FabricItemStack.New.removeItemFlag(this.fabricValue(), itemFlag);
                }
            } else if (this.itemMeta) {
                ItemMeta meta = this.bukkitValue().getItemMeta();
                if (itemFlag == ItemFlagAdapter.HIDE_ATTRIBUTES && VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_20_5)) {
                    meta.setAttributeModifiers(null);
                }
                meta.removeItemFlags(new ItemFlag[]{itemFlag.bukkitValue()});
                this.bukkitValue().setItemMeta(meta);
            }
            this.itemFlags.remove(itemFlag);
        }
        return this;
    }

    public boolean isPlayerHead() {
        switch (this.type.getID()) {
            case "minecraft:player_head": 
            case "player_head": 
            case "PLAYER_HEAD": {
                return true;
            }
            case "minecraft:skull": 
            case "skull": 
            case "SKULL_ITEM": 
            case "SKULL": {
                return this.getDamage() == 3;
            }
        }
        return false;
    }

    public String getSkullOwner() {
        return this.skullOwner;
    }

    public CompletableFuture<ItemStackAdapter> setSkullOwner(String skullOwner, boolean snapshot) {
        CompletableFuture<ItemStackAdapter> future = new CompletableFuture<ItemStackAdapter>();
        if (this.isPlayerHead()) {
            if (skullOwner == null) {
                this.setSkullProfile(null, null, null);
            } else {
                if (!PlayerManager.getInstance().isValidUsername(skullOwner)) {
                    throw new IllegalArgumentException("Username \"" + skullOwner + "\" does not respect the following pattern: \"" + PlayerManager.getInstance().getUsernamePattern().pattern() + "\"");
                }
                if (!skullOwner.equalsIgnoreCase(this.skullOwner) && !nonPremiumUsernames.contains(skullOwner.toLowerCase())) {
                    Object[] cache = skullsCache.get(skullOwner.toLowerCase());
                    if (cache == null) {
                        TaskManager.runAsync(() -> {
                            try {
                                UUID uuid = UUIDFetcher.getInstance().getOnlineUUID(skullOwner).get();
                                String onlineName = UUIDFetcher.getInstance().getName(uuid).get();
                                skullsCache.put(skullOwner.toLowerCase(), new Object[]{uuid, onlineName, UUIDFetcher.getInstance().getSkinTextureURL(uuid).get()});
                                this.skullOwner = onlineName;
                                this.setSkullProfile(uuid, this.skullOwner, snapshot ? (String)skullsCache.get(skullOwner.toLowerCase())[2] : null);
                            }
                            catch (InterruptedException | ExecutionException e) {
                                if (e.getCause() instanceof NoSuchElementException) {
                                    nonPremiumUsernames.add(skullOwner.toLowerCase());
                                }
                                LogManager.log("{0} occurred while setting a skull's owner for an item stack: {1}", 2, e.getClass().getSimpleName(), e.getLocalizedMessage());
                            }
                            future.complete(this);
                        }, 0L);
                        return future;
                    }
                    this.setSkullProfile((UUID)cache[0], (String)cache[1], snapshot ? (String)cache[2] : null);
                }
            }
            this.skullOwner = skullOwner;
        }
        future.complete(this);
        return future;
    }

    /*
     * Unable to fully structure code
     */
    public String getSkullTextureURL() {
        if (!this.isPlayerHead()) {
            return null;
        }
        value = null;
        if (!Environment.isBukkit()) ** GOTO lbl21
        meta = this.bukkitValue().getItemMeta();
        if (VersionUtils.getVersion().isOlderThan(VersionUtils.Version.V1_20_2)) {
            try {
                field = meta.getClass().getDeclaredField("profile");
                field.setAccessible(true);
                profile = (GameProfile)field.get(meta);
                if (profile == null || (property = (Property)Iterables.getFirst((Iterable)((PropertyMap)GameProfile.class.getMethod("getProperties", new Class[0]).invoke((Object)profile, new Object[0])).get((Object)"textures"), null)) == null) ** GOTO lbl45
                value = (String)Property.class.getMethod("getValue", new Class[0]).invoke((Object)property, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        } else {
            profile = ((SkullMeta)meta).getOwnerProfile();
            if (profile != null && (skin = profile.getTextures().getSkin()) != null) {
                return skin.toExternalForm();
            }
            return null;
lbl21:
            // 1 sources

            if (Environment.isSponge()) {
                map = ((org.spongepowered.api.profile.GameProfile)((RepresentedPlayerData)this.spongeValue().getOrCreate(RepresentedPlayerData.class).get()).owner().get()).getPropertyMap();
                if (map != null && (property = (ProfileProperty)Iterables.getFirst((Iterable)map.get((Object)"textures"), null)) != null) {
                    value = property.getValue();
                }
            } else {
                try {
                    if (VersionUtils.getVersion().isOlderThan(VersionUtils.Version.V1_20_5)) {
                        nbt = (class_2487)class_1799.class.getMethod("method_7969", new Class[0]).invoke((Object)this.fabricValue(), new Object[0]);
                        if (nbt != null && (Byte)class_2487.class.getMethod("method_10540", new Class[]{String.class}).invoke((Object)nbt, new Object[]{"SkullOwner"}) == 10 && (profile = (GameProfile)class_2512.class.getMethod("method_10683", new Class[]{class_2487.class}).invoke(null, new Object[]{class_2487.class.getMethod("method_10580", new Class[]{String.class}).invoke((Object)nbt, new Object[]{"SkullOwner"})})) != null) {
                            if (VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_20_2)) {
                                property = (Property)Iterables.getFirst((Iterable)(VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_21_9) != false ? profile.properties() : GameProfile.class.getMethod("getProperties", new Class[0]).invoke((Object)profile, new Object[0])).get((Object)"textures"), null);
                                if (property != null) {
                                    value = property.value();
                                }
                            } else {
                                property = (Property)Iterables.getFirst((Iterable)((PropertyMap)GameProfile.class.getMethod("getProperties", new Class[0]).invoke((Object)profile, new Object[0])).get((Object)"textures"), null);
                                if (property != null) {
                                    value = (String)Property.class.getMethod("getValue", new Class[0]).invoke((Object)property, new Object[0]);
                                }
                            }
                        }
                    } else {
                        profile = (class_9296)FabricItemStack.New.get(this.fabricValue(), class_9334.field_49617);
                        if (profile != null && (property = (Property)Iterables.getFirst((Iterable)(VersionUtils.getVersion().isOlderThan(VersionUtils.Version.V1_21_9) != false ? (PropertyMap)GameProfile.class.getMethod("getProperties", new Class[0]).invoke(class_9296.class.getMethod("comp_2413", new Class[0]).invoke((Object)profile, new Object[0]), new Object[0]) : profile.method_73313().properties()).get((Object)"textures"), null)) != null) {
                            value = property.value();
                        }
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
lbl45:
        // 7 sources

        if (value != null) {
            try {
                value = new String(Base64.getDecoder().decode(value), StandardCharsets.ISO_8859_1);
                index = value.indexOf("\"http") + 1;
                return value.substring(index, value.indexOf(34, index));
            }
            catch (IndexOutOfBoundsException ioobe) {
                ioobe.printStackTrace();
            }
        }
        return null;
    }

    public ItemStackAdapter setSkullTextureURL(String skullTextureURL) {
        return this.isPlayerHead() ? this.setSkullProfile(UUID.randomUUID(), "chatplugin", skullTextureURL) : this;
    }

    private ItemStackAdapter setSkullProfile(UUID uuid, String name, String skullTextureURL) {
        if (Environment.isBukkit()) {
            ItemMeta meta = this.bukkitValue().getItemMeta();
            if (VersionUtils.getVersion().isOlderThan(VersionUtils.Version.V1_20_2)) {
                try {
                    GameProfile profile;
                    GameProfile gameProfile = profile = uuid == null ? null : new GameProfile(uuid, name);
                    if (skullTextureURL != null) {
                        ((PropertyMap)GameProfile.class.getMethod("getProperties", new Class[0]).invoke((Object)profile, new Object[0])).put((Object)"textures", (Object)new Property("textures", new String(Base64.getEncoder().encode(("{textures:{SKIN:{url:\"" + skullTextureURL + "\"}}}").getBytes()), StandardCharsets.ISO_8859_1)));
                    }
                    Field field = meta.getClass().getDeclaredField("profile");
                    field.setAccessible(true);
                    field.set(meta, profile);
                    this.bukkitValue().setItemMeta(meta);
                }
                catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                    LogManager.log("{0} occurred while setting a skull's profile for an item stack: {1}", 2, e.getClass().getSimpleName(), e.getLocalizedMessage());
                }
            } else {
                PlayerProfile profile = uuid == null ? null : Bukkit.createPlayerProfile((UUID)uuid, (String)name);
                try {
                    if (skullTextureURL != null) {
                        PlayerTextures textures = profile.getTextures();
                        textures.setSkin(new URI(skullTextureURL).toURL());
                        profile.setTextures(textures);
                    }
                    ((SkullMeta)meta).setOwnerProfile(profile);
                    this.bukkitValue().setItemMeta(meta);
                }
                catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
                    LogManager.log("{0} occurred while setting a skull's profile for an item stack: {1}", 2, e.getClass().getSimpleName(), e.getLocalizedMessage());
                }
            }
        } else if (Environment.isSponge()) {
            if (uuid != null) {
                org.spongepowered.api.profile.GameProfile profile = Sponge.getServer().getGameProfileManager().createProfile(uuid, name);
                if (skullTextureURL != null) {
                    profile.addProperty("textures", ProfileProperty.of((String)"textures", (String)new String(Base64.getEncoder().encode(("{textures:{SKIN:{url:\"" + skullTextureURL + "\"}}}").getBytes()), StandardCharsets.ISO_8859_1)));
                }
                this.spongeValue().offer(Keys.REPRESENTED_PLAYER, (Object)profile);
            } else {
                this.spongeValue().remove(Keys.REPRESENTED_PLAYER);
            }
        } else {
            FabricItemStack.setSkullProfile(this.fabricValue(), uuid, name, skullTextureURL);
        }
        return this;
    }

    public boolean isLeatherArmor() {
        return this.type.getID().toLowerCase().contains("leather_");
    }

    public Color getLeatherArmorColor() {
        if (this.isLeatherArmor()) {
            if (Environment.isBukkit()) {
                return new Color(((LeatherArmorMeta)this.bukkitValue().getItemMeta()).getColor().asRGB());
            }
            if (Environment.isSponge()) {
                return ((DyeColor)((DyeableData)this.spongeValue().getOrCreate(DyeableData.class).get()).type().get()).getColor().asJavaColor();
            }
            if (Environment.isFabric()) {
                try {
                    if (VersionUtils.getVersion().isOlderThan(VersionUtils.Version.V1_20_5)) {
                        class_2487 nbt = (class_2487)class_1799.class.getMethod("method_7941", new Class[0]).invoke((Object)this.fabricValue(), "display");
                        return nbt == null || (Byte)class_2487.class.getMethod("method_10540", String.class).invoke((Object)nbt, "color") != 99 ? Color.decode("#A06540") : new Color((Integer)class_2487.class.getMethod("method_10550", String.class).invoke((Object)nbt, "color"));
                    }
                    return new Color(((class_9282)FabricItemStack.New.get(this.fabricValue(), class_9334.field_49644)).comp_2384());
                }
                catch (JsonSyntaxException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public ItemStackAdapter setLeatherArmorColor(Color leatherArmorColor) {
        if (this.isLeatherArmor()) {
            Color color = leatherArmorColor = leatherArmorColor == null ? Color.decode("#A06540") : leatherArmorColor;
            if (Environment.isBukkit()) {
                ItemMeta meta = this.bukkitValue().getItemMeta();
                ((LeatherArmorMeta)meta).setColor(org.bukkit.Color.fromRGB((int)leatherArmorColor.getRed(), (int)leatherArmorColor.getGreen(), (int)leatherArmorColor.getBlue()));
                this.bukkitValue().setItemMeta(meta);
            } else if (Environment.isSponge()) {
                SpongeItemStack.setLeatherArmorColor(this.spongeValue(), leatherArmorColor);
            } else if (VersionUtils.getVersion().isOlderThan(VersionUtils.Version.V1_20_5)) {
                try {
                    ((class_2487)class_1799.class.getMethod("method_7911", String.class).invoke((Object)this.fabricValue(), "display")).method_10569("color", leatherArmorColor.getRGB());
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            } else {
                this.fabricValue().method_57379(class_9334.field_49644, (Object)new class_9282(leatherArmorColor.getRGB()));
            }
        }
        return this;
    }

    public ItemStackAdapter importData(ItemStackAdapter other) {
        this.setAmount(other.getAmount());
        this.setDamage(other.getDamage());
        this.disenchant();
        this.enchant(other.getEnchantments());
        this.setDisplayName(other.getDisplayName());
        this.setLore(other.getLore());
        this.removeItemFlags(ItemFlagAdapter.values());
        this.addItemFlags(other.getItemFlags().toArray(new ItemFlagAdapter[other.getItemFlags().size()]));
        if (other.getSkullOwner() != null) {
            if (!this.getSkullOwner().equals(other.getSkullOwner())) {
                this.setSkullOwner(other.getSkullOwner(), other.getSkullTextureURL() != null);
            }
        } else if (other.getSkullTextureURL() != null && !this.getSkullTextureURL().equals(other.getSkullTextureURL())) {
            this.setSkullTextureURL(other.getSkullTextureURL());
        }
        this.setLeatherArmorColor(other.getLeatherArmorColor());
        return this;
    }

    private static class FabricItemStack {
        private FabricItemStack() {
        }

        public static class_1799 newInstance(MaterialAdapter type, short amount) {
            return new class_1799((class_1935)type.fabricValue(), (int)amount);
        }

        public static void setDisplayName(class_1799 itemStack, String displayName) {
            if (VersionUtils.getVersion().isOlderThan(VersionUtils.Version.V1_20_5)) {
                try {
                    Object text;
                    class_2561 class_25612 = text = displayName == null ? null : Utils.toFabricComponent(displayName);
                    if (text != null) {
                        text = VersionUtils.getVersion().isOlderThan(VersionUtils.Version.V1_16) ? class_2561.class.getMethod("method_10862", class_2583.class).invoke(text, ((class_2583)class_2583.class.getConstructor(new Class[0]).newInstance(new Object[0])).method_10978(Boolean.valueOf(false))) : class_5250.class.getMethod("method_27696", class_2583.class).invoke((Object)text.method_27661(), class_2583.field_24360.method_10978(Boolean.valueOf(false)));
                    }
                    class_1799.class.getMethod("method_7977", class_2561.class).invoke((Object)itemStack, text);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            } else {
                New.setDisplayName(itemStack, displayName);
            }
        }

        public static List<String> getLore(class_1799 itemStack) {
            try {
                if (VersionUtils.getVersion().isOlderThan(VersionUtils.Version.V1_20_5)) {
                    class_2499 lore = (class_2499)class_2487.class.getMethod("method_10554", String.class, Integer.TYPE).invoke(class_1799.class.getMethod("method_7911", String.class).invoke((Object)itemStack, "display"), "Lore", 8);
                    ArrayList<String> list = new ArrayList<String>(lore.size());
                    Method toLegacyText = Class.forName("me.remigio07.chatplugin.common.util.Utils", false, JARLibraryLoader.getInstance()).getMethod("toLegacyText", String.class);
                    for (int i = 0; i < lore.size(); ++i) {
                        list.add((String)toLegacyText.invoke(null, lore.method_10608(i)));
                    }
                    return list;
                }
                return ((class_9290)New.get(itemStack, class_9334.field_49632)).comp_2400().stream().map(Utils::toLegacyText).collect(Collectors.toList());
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }

        public static void setLore(class_1799 itemStack, List<String> lore) {
            block6: {
                if (VersionUtils.getVersion().isOlderThan(VersionUtils.Version.V1_20_5)) {
                    try {
                        class_2487 nbt = (class_2487)class_1799.class.getMethod("method_7911", String.class).invoke((Object)itemStack, "display");
                        if (lore != null) {
                            class_2499 list = new class_2499();
                            for (String line : lore) {
                                Object text = Utils.toFabricComponent(line.replace("\n", " ").replace("\r\n", " ").replace("\r", " "));
                                text = VersionUtils.getVersion().isOlderThan(VersionUtils.Version.V1_16) ? (class_2561)class_2561.class.getMethod("method_10862", class_2583.class).invoke(text, ((class_2583)class_2583.class.getConstructor(new Class[0]).newInstance(new Object[0])).method_10978(Boolean.valueOf(false))) : class_5250.class.getMethod("method_27696", class_2583.class).invoke((Object)text.method_27661(), class_2583.field_24360.method_10978(Boolean.valueOf(false)));
                                Constructor constructor = class_2519.class.getDeclaredConstructor(String.class);
                                constructor.setAccessible(true);
                                list.add((Object)((class_2520)constructor.newInstance(((JsonElement)Class.forName("me.remigio07.chatplugin.server.fabric.ChatPluginFabric", false, JARLibraryLoader.getInstance()).getMethod("toJSON", class_2561.class).invoke(null, text)).toString())));
                            }
                            nbt.method_10566("Lore", (class_2520)list);
                            break block6;
                        }
                        class_2487.class.getMethod("method_10551", String.class).invoke((Object)nbt, "Lore");
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                } else {
                    itemStack.method_57379(class_9334.field_49632, (Object)(lore == null ? null : new class_9290(lore.stream().map(str -> Utils.toFabricComponent(str.replace("\n", " ").replace("\r\n", " ").replace("\r", " ")).method_27661().method_27696(class_2583.field_24360.method_10978(Boolean.valueOf(false)))).collect(Collectors.toList()))));
                }
            }
        }

        public static void setSkullProfile(class_1799 itemStack, UUID uuid, String name, String skullTextureURL) {
            try {
                if (VersionUtils.getVersion().isOlderThan(VersionUtils.Version.V1_20_5)) {
                    class_2487 nbt = (class_2487)class_1799.class.getMethod("method_7948", new Class[0]).invoke((Object)itemStack, new Object[0]);
                    if (uuid != null) {
                        GameProfile profile = new GameProfile(uuid, name);
                        if (skullTextureURL != null) {
                            ((PropertyMap)GameProfile.class.getMethod("getProperties", new Class[0]).invoke((Object)profile, new Object[0])).put((Object)"textures", (Object)new Property("textures", new String(Base64.getEncoder().encode(("{textures:{SKIN:{url:\"" + skullTextureURL + "\"}}}").getBytes()), StandardCharsets.ISO_8859_1)));
                        }
                        nbt.method_10566("SkullOwner", (class_2520)((class_2487)class_2512.class.getMethod("method_10684", class_2487.class, GameProfile.class).invoke(null, new class_2487(), profile)));
                    } else {
                        class_2487.class.getMethod("method_10551", String.class).invoke((Object)nbt, "SkullOwner");
                    }
                } else if (uuid != null) {
                    if (VersionUtils.getVersion().isOlderThan(VersionUtils.Version.V1_21_9)) {
                        PropertyMap map = (PropertyMap)PropertyMap.class.getConstructor(new Class[0]).newInstance(new Object[0]);
                        if (skullTextureURL != null) {
                            map.put((Object)"textures", (Object)new Property("textures", new String(Base64.getEncoder().encode(("{textures:{SKIN:{url:\"" + skullTextureURL + "\"}}}").getBytes()), StandardCharsets.ISO_8859_1)));
                        }
                        itemStack.method_57379(class_9334.field_49617, (Object)((class_9296)class_9296.class.getConstructor(Optional.class, Optional.class, PropertyMap.class).newInstance(Optional.of(name), Optional.of(uuid), map)));
                    } else {
                        itemStack.method_57379(class_9334.field_49617, (Object)class_9296.method_73307((GameProfile)new GameProfile(uuid, name, skullTextureURL == null ? PropertyMap.EMPTY : new PropertyMap((Multimap)ImmutableListMultimap.of((Object)"textures", (Object)new Property("textures", new String(Base64.getEncoder().encode(("{textures:{SKIN:{url:\"" + skullTextureURL + "\"}}}").getBytes()), StandardCharsets.ISO_8859_1)))))));
                    }
                } else {
                    itemStack.method_57381(class_9334.field_49617);
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }

        private static class New {
            public static final Set<class_9331<?>> MISCELLANEOUS_COMPONENTS = VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_21_5) ? Stream.of(ItemFlagAdapter.HIDE_MISCELLANEOUS.getComponents()).map(component -> (class_9331)class_7923.field_49658.method_63535(class_2960.method_60656((String)component))).filter(Objects::nonNull).collect(Collectors.toSet()) : null;

            private New() {
            }

            public static <T> T get(class_1799 itemStack, class_9331<? extends T> component) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
                return (T)(VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_21_5) ? itemStack.method_58694(component) : class_1799.class.getMethod("method_57824", class_9331.class).invoke((Object)itemStack, component));
            }

            public static void setDisplayName(class_1799 itemStack, String displayName) {
                itemStack.method_57379(class_9334.field_49631, displayName == null ? null : Utils.toFabricComponent(displayName).method_27661().method_27696(class_2583.field_24360.method_10978(Boolean.valueOf(false))));
            }

            public static void addItemFlag(class_1799 itemStack, ItemFlagAdapter itemFlag) {
                if (VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_21_5)) {
                    class_10712 tooltip = (class_10712)itemStack.method_58694(class_9334.field_56400);
                    LinkedHashSet hiddenComponents = new LinkedHashSet();
                    if (tooltip != null) {
                        hiddenComponents.addAll(tooltip.comp_3601());
                    }
                    if (itemFlag == ItemFlagAdapter.HIDE_MISCELLANEOUS) {
                        hiddenComponents.addAll(MISCELLANEOUS_COMPONENTS);
                    } else {
                        hiddenComponents.add(itemFlag.fabricValue());
                    }
                    itemStack.method_57379(class_9334.field_56400, (Object)new class_10712(false, hiddenComponents));
                } else {
                    New.withShowInTooltip(itemStack, itemFlag, false);
                }
            }

            public static void removeItemFlag(class_1799 itemStack, ItemFlagAdapter itemFlag) {
                if (VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_21_5)) {
                    class_10712 tooltip = (class_10712)itemStack.method_58694(class_9334.field_56400);
                    if (tooltip != null) {
                        LinkedHashSet hiddenComponents = new LinkedHashSet(tooltip.comp_3601());
                        if (itemFlag == ItemFlagAdapter.HIDE_MISCELLANEOUS) {
                            hiddenComponents.removeAll(MISCELLANEOUS_COMPONENTS);
                        } else {
                            hiddenComponents.remove(itemFlag.fabricValue());
                        }
                        itemStack.method_57379(class_9334.field_56400, (Object)new class_10712(false, hiddenComponents));
                    }
                } else {
                    New.withShowInTooltip(itemStack, itemFlag, true);
                }
            }

            private static void withShowInTooltip(class_1799 itemStack, ItemFlagAdapter itemFlag, boolean showInTooltip) {
                class_9326.class_9327 builder = class_9326.method_57841();
                try {
                    if (itemFlag == ItemFlagAdapter.HIDE_ENCHANTMENTS) {
                        if (itemStack.method_7942()) {
                            builder.method_57854(class_9334.field_49633, (Object)New.withShowInTooltip(itemStack.method_58657(), "method_58449", showInTooltip));
                        }
                    } else if (itemFlag == ItemFlagAdapter.HIDE_ATTRIBUTES) {
                        if (itemStack.method_57826(class_9334.field_49636)) {
                            builder.method_57854(class_9334.field_49636, (Object)New.withShowInTooltip((class_9285)New.get(itemStack, class_9334.field_49636), "method_58423", showInTooltip));
                        }
                    } else if (itemFlag == ItemFlagAdapter.HIDE_UNBREAKABLE) {
                        if (itemStack.method_57826(class_9334.field_49630)) {
                            builder.method_57854((class_9331)class_9334.class.getField("field_49630").get(null), Class.forName("net.minecraft.class_9300").getConstructor(Boolean.TYPE).newInstance(showInTooltip));
                        }
                    } else if (itemFlag == ItemFlagAdapter.HIDE_CAN_DESTROY) {
                        if (itemStack.method_57826(class_9334.field_49635)) {
                            builder.method_57854(class_9334.field_49635, (Object)New.withShowInTooltip((class_6538)New.get(itemStack, class_9334.field_49635), "method_58402", showInTooltip));
                        }
                    } else if (itemFlag == ItemFlagAdapter.HIDE_CAN_BE_PLACED_ON) {
                        if (itemStack.method_57826(class_9334.field_49634)) {
                            builder.method_57854(class_9334.field_49634, (Object)New.withShowInTooltip((class_6538)New.get(itemStack, class_9334.field_49634), "method_58402", showInTooltip));
                        }
                    } else if (itemFlag == ItemFlagAdapter.HIDE_MISCELLANEOUS) {
                        if (VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_21)) {
                            builder.method_57854(class_9334.field_52175, (Object)New.withShowInTooltip((class_9792)New.get(itemStack, class_9334.field_52175), "method_60749", showInTooltip));
                        }
                        if (showInTooltip) {
                            itemStack.method_57381((class_9331)class_9334.class.getField("field_49638").get(null));
                        } else {
                            builder.method_57854((class_9331)class_9334.class.getField("field_49638").get(null), (Object)class_3902.field_17274);
                        }
                    } else if (itemFlag == ItemFlagAdapter.HIDE_DYE) {
                        if (itemStack.method_57826(class_9334.field_49644)) {
                            builder.method_57854(class_9334.field_49644, (Object)New.withShowInTooltip((class_9282)New.get(itemStack, class_9334.field_49644), "method_58422", showInTooltip));
                        }
                    } else if (itemFlag == ItemFlagAdapter.HIDE_ARMOR_TRIM && itemStack.method_57826(class_9334.field_49607)) {
                        builder.method_57854(class_9334.field_49607, (Object)New.withShowInTooltip((class_8053)New.get(itemStack, class_9334.field_49607), "method_58421", showInTooltip));
                    }
                    itemStack.method_59692(builder.method_57852());
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }

            private static <T> T withShowInTooltip(T instance, String method, boolean showInTooltip) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
                return (T)instance.getClass().getMethod(method, Boolean.TYPE).invoke(instance, showInTooltip);
            }

            private static boolean showInTooltip(Object instance, String field) throws NoSuchFieldException, IllegalAccessException, InvocationTargetException {
                if (instance == null) {
                    return true;
                }
                Field showInTooltip = instance.getClass().getDeclaredField(field);
                showInTooltip.setAccessible(true);
                return (Boolean)showInTooltip.get(instance);
            }
        }
    }

    private static class SpongeItemStack {
        private SpongeItemStack() {
        }

        public static short getDamage(org.spongepowered.api.item.inventory.ItemStack itemStack) {
            return ((Integer)itemStack.toContainer().get(DataQuery.of((String[])new String[]{"UnsafeDamage"})).get()).shortValue();
        }

        public static org.spongepowered.api.item.inventory.ItemStack setDamage(org.spongepowered.api.item.inventory.ItemStack itemStack, short damage) {
            return org.spongepowered.api.item.inventory.ItemStack.builder().fromContainer((DataView)itemStack.toContainer().set(DataQuery.of((String[])new String[]{"UnsafeDamage"}), (Object)damage)).build();
        }

        public static void enchant(org.spongepowered.api.item.inventory.ItemStack item, EnchantmentType enchantment, int level) {
            EnchantmentData data = (EnchantmentData)item.getOrCreate(EnchantmentData.class).get();
            data.addElement((Object)Enchantment.of((EnchantmentType)enchantment, (int)level));
            item.offer((ValueContainer)data);
        }

        public static void disenchant(org.spongepowered.api.item.inventory.ItemStack item, EnchantmentType enchantment) {
            EnchantmentData data = (EnchantmentData)item.getOrCreate(EnchantmentData.class).get();
            List enchantments = (List)data.enchantments().get();
            for (int i = 0; i < enchantments.size(); ++i) {
                if (!((Enchantment)enchantments.get(i)).getType().equals((Object)enchantment)) continue;
                enchantments.remove(i);
            }
            item.offer((ValueContainer)data);
        }

        public static void setLeatherArmorColor(org.spongepowered.api.item.inventory.ItemStack item, final Color color) {
            DyeableData data = (DyeableData)item.getOrCreate(DyeableData.class).get();
            final String hex = "#" + Integer.toHexString(color.getRGB()).substring(2).toUpperCase();
            data.type().set((Object)new DyeColor(){

                public Translation getTranslation() {
                    return new FixedTranslation(hex);
                }

                public String getName() {
                    return hex;
                }

                public String getId() {
                    return hex;
                }

                public org.spongepowered.api.util.Color getColor() {
                    return org.spongepowered.api.util.Color.of((Color)color);
                }
            });
            item.offer((ValueContainer)data);
        }

        public static List<Text> toTextList(List<String> list) {
            return list.stream().map(string -> Utils.toSpongeComponent(string.replace("\n", " ").replace("\r\n", " ").replace("\r", " "))).collect(Collectors.toList());
        }

        public static List<String> toStringList(List<Text> list) {
            return list.stream().map(Utils::toLegacyText).collect(Collectors.toList());
        }
    }
}

