/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.util.adapter.inventory.item;

import java.lang.reflect.InvocationTargetException;
import me.remigio07.chatplugin.api.common.util.PseudoEnum;
import me.remigio07.chatplugin.api.common.util.VersionUtils;
import me.remigio07.chatplugin.bootstrap.Environment;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9331;
import org.bukkit.inventory.ItemFlag;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.mutable.Value;

public class ItemFlagAdapter
extends PseudoEnum<ItemFlagAdapter> {
    public static final ItemFlagAdapter HIDE_ENCHANTMENTS = new ItemFlagAdapter("HIDE_ENCHANTMENTS", "HIDE_ENCHANTS", "HIDE_ENCHANTMENTS", "enchantments");
    public static final ItemFlagAdapter HIDE_ATTRIBUTES = new ItemFlagAdapter("HIDE_ATTRIBUTES", "HIDE_ATTRIBUTES", "HIDE_ATTRIBUTES", "attribute_modifiers");
    public static final ItemFlagAdapter HIDE_UNBREAKABLE = new ItemFlagAdapter("HIDE_UNBREAKABLE", "HIDE_UNBREAKABLE", "HIDE_UNBREAKABLE", "unbreakable");
    public static final ItemFlagAdapter HIDE_CAN_DESTROY = new ItemFlagAdapter("HIDE_CAN_DESTROY", "HIDE_DESTROYS", "HIDE_CAN_DESTROY", "can_break");
    public static final ItemFlagAdapter HIDE_CAN_BE_PLACED_ON = new ItemFlagAdapter("HIDE_CAN_BE_PLACED_ON", "HIDE_PLACED_ON", "HIDE_CAN_PLACE", "can_place_on");
    public static final ItemFlagAdapter HIDE_MISCELLANEOUS = new ItemFlagAdapter(new String[]{VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_20_5) ? "HIDE_ADDITIONAL_TOOLTIP" : "HIDE_POTION_EFFECTS", "HIDE_MISCELLANEOUS", VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_21_5) ? "tooltip_display" : "hide_additional_tooltip"}, "banner_patterns", "bees", "block_entity_data", "block_state", "bundle_contents", "charged_projectiles", "container", "container_loot", "firework_explosion", "fireworks", "instrument", "intangible_projectile", "jukebox_playable", "map_id", "ominous_bottle_amplifier", "painting/variant", "pot_decorations", "potion_contents", "profile", "stored_enchantments", "suspicious_stew_effects", "tropical_fish/pattern", "written_book_content");
    public static final ItemFlagAdapter HIDE_DYE = new ItemFlagAdapter(VersionUtils.Version.V1_16_2, "HIDE_DYE", "HIDE_MISCELLANEOUS", "dyed_color");
    public static final ItemFlagAdapter HIDE_ARMOR_TRIM = new ItemFlagAdapter(VersionUtils.Version.V1_19_4, "HIDE_ARMOR_TRIM", "HIDE_MISCELLANEOUS", "trim");
    private static final ItemFlagAdapter[] VALUES = new ItemFlagAdapter[]{HIDE_ENCHANTMENTS, HIDE_ATTRIBUTES, HIDE_UNBREAKABLE, HIDE_CAN_DESTROY, HIDE_CAN_BE_PLACED_ON, HIDE_MISCELLANEOUS, HIDE_DYE, HIDE_ARMOR_TRIM};
    private static int ordinal = 0;
    private String[] ids;
    private String[] components;
    private VersionUtils.Version minimumVersion;

    private ItemFlagAdapter(String name, String ... ids) {
        this(name, ids, new String[]{ids[2]}, (VersionUtils.Version)null);
    }

    private ItemFlagAdapter(String[] ids, String ... components) {
        this(ids[1], ids, components, (VersionUtils.Version)null);
    }

    private ItemFlagAdapter(VersionUtils.Version minimumVersion, String ... ids) {
        this(ids[0], ids, new String[]{ids[2]}, minimumVersion);
    }

    private ItemFlagAdapter(String name, String[] ids, String[] components, VersionUtils.Version minimumVersion) {
        super(name, ordinal++);
        this.ids = ids;
        this.components = components;
        this.minimumVersion = minimumVersion;
    }

    public ItemFlag bukkitValue() {
        if (Environment.isBukkit()) {
            try {
                return ItemFlag.valueOf((String)this.ids[0]);
            }
            catch (IllegalArgumentException e) {
                return ItemFlag.HIDE_ATTRIBUTES;
            }
        }
        throw new UnsupportedOperationException("Unable to adapt item flag to a Bukkit's ItemFlag on a " + Environment.getCurrent().getName() + " environment");
    }

    public Key<Value<Boolean>> spongeValue() {
        if (Environment.isSponge()) {
            try {
                return (Key)Keys.class.getField(this.ids[1]).get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NullPointerException e) {
                return Keys.HIDE_ATTRIBUTES;
            }
        }
        throw new UnsupportedOperationException("Unable to adapt item flag to a Sponge's Key<Value<Boolean>> on a " + Environment.getCurrent().getName() + " environment");
    }

    public byte bitModifierValue() {
        return (byte)(1 << this.ordinal());
    }

    public Object oldFabricValue() {
        if (Environment.isFabric()) {
            try {
                return this == HIDE_ARMOR_TRIM && VersionUtils.getVersion().isOlderThan(VersionUtils.Version.V1_19_4) ? HIDE_ATTRIBUTES : Class.forName("net.minecraft.class_1799$class_5422").getEnumConstants()[this.ordinal()];
            }
            catch (ClassNotFoundException cnfe) {
                throw new UnsupportedOperationException("Unable to call this 1.16.2-1.20.4 method on a " + VersionUtils.getVersion().getName() + " server");
            }
        }
        throw new UnsupportedOperationException("Unable to adapt item flag to an old Fabric's ItemStack.TooltipSection on a " + Environment.getCurrent().getName() + " environment");
    }

    public class_9331<?> fabricValue() {
        if (Environment.isFabric()) {
            if (VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_20_5)) {
                if (VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_21_2)) {
                    return (class_9331)class_7923.field_49658.method_63535(class_2960.method_60656((String)this.ids[2]));
                }
                try {
                    return (class_9331)class_2378.class.getMethod("method_10223", class_2960.class).invoke((Object)class_7923.field_49658, class_2960.method_43902((String)"minecraft", (String)this.ids[2]));
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            throw new UnsupportedOperationException("Unable to call this 1.20.5+ method on a " + VersionUtils.getVersion().getName() + " server");
        }
        throw new UnsupportedOperationException("Unable to adapt item flag to a Fabric's ComponentType<?> on a " + Environment.getCurrent().getName() + " environment");
    }

    public String[] getIDs() {
        return this.ids;
    }

    public String[] getComponents() {
        return this.components;
    }

    public VersionUtils.Version getMinimumVersion() {
        return this.minimumVersion;
    }

    public boolean isSupported() {
        return this.minimumVersion == null || VersionUtils.getVersion().isAtLeast(this.minimumVersion);
    }

    public static ItemFlagAdapter valueOf(String name) {
        return (ItemFlagAdapter)ItemFlagAdapter.valueOf((String)name, (PseudoEnum[])VALUES);
    }

    public static ItemFlagAdapter[] values() {
        return VALUES;
    }

    public static ItemFlagAdapter value(String name) {
        name = name.toUpperCase();
        for (ItemFlagAdapter value : VALUES) {
            String[] ids;
            if (!value.name().equals(name) && !(ids = value.getIDs())[0].equals(name) && !ids[1].equals(name)) continue;
            return value;
        }
        return null;
    }
}

