/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.util.adapter.bossbar;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.remigio07.chatplugin.api.common.util.PseudoEnum;
import me.remigio07.chatplugin.api.common.util.VersionUtils;
import me.remigio07.chatplugin.bootstrap.Environment;
import net.minecraft.class_1259;
import org.bukkit.boss.BarStyle;
import org.spongepowered.api.boss.BossBarOverlay;
import org.spongepowered.api.boss.BossBarOverlays;

public class BossbarStyleAdapter
extends PseudoEnum<BossbarStyleAdapter> {
    public static final BossbarStyleAdapter NOTCHED_6 = new BossbarStyleAdapter("NOTCHED_6", "SEGMENTED_6");
    public static final BossbarStyleAdapter NOTCHED_10 = new BossbarStyleAdapter("NOTCHED_10", "SEGMENTED_10");
    public static final BossbarStyleAdapter NOTCHED_12 = new BossbarStyleAdapter("NOTCHED_12", "SEGMENTED_12");
    public static final BossbarStyleAdapter NOTCHED_20 = new BossbarStyleAdapter("NOTCHED_20", "SEGMENTED_20");
    public static final BossbarStyleAdapter PROGRESS = new BossbarStyleAdapter("PROGRESS", "SOLID");
    public static final BossbarStyleAdapter RANDOM = new BossbarStyleAdapter("RANDOM", "RANDOM");
    private static final BossbarStyleAdapter[] VALUES = new BossbarStyleAdapter[]{NOTCHED_6, NOTCHED_10, NOTCHED_12, NOTCHED_20, PROGRESS, RANDOM};
    private static int ordinal = 0;
    private static Map<String, Object> spongeStyles;
    private String bukkitID;

    private BossbarStyleAdapter(String name, String bukkitID) {
        super(name, ordinal++);
        this.bukkitID = bukkitID;
    }

    public BarStyle bukkitValue() {
        if (Environment.isBukkit()) {
            return this == RANDOM ? BarStyle.values()[VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_9) ? ThreadLocalRandom.current().nextInt(BarStyle.values().length) : 4] : BarStyle.valueOf((String)this.bukkitID);
        }
        throw new UnsupportedOperationException("Unable to adapt bossbar style to a Bukkit's BarStyle on a " + Environment.getCurrent().getName() + " environment");
    }

    public BossBarOverlay spongeValue() {
        if (Environment.isSponge()) {
            return (BossBarOverlay)(this == RANDOM ? new ArrayList<Object>(spongeStyles.values()).get(VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_9) ? ThreadLocalRandom.current().nextInt(VALUES.length - 1) : 0) : spongeStyles.get(this.name()));
        }
        throw new UnsupportedOperationException("Unable to adapt bossbar style to a Sponge's BossBarOverlay on a " + Environment.getCurrent().getName() + " environment");
    }

    public class_1259.class_1261 fabricValue() {
        if (Environment.isFabric()) {
            return this == RANDOM ? class_1259.class_1261.values()[ThreadLocalRandom.current().nextInt(class_1259.class_1261.values().length)] : class_1259.class_1261.valueOf((String)this.name());
        }
        throw new UnsupportedOperationException("Unable to adapt bossbar style to a Fabric's BossBar.Style on a " + Environment.getCurrent().getName() + " environment");
    }

    public String getBukkitID() {
        return this.bukkitID;
    }

    public boolean isSupported() {
        return Environment.isFabric() || this == PROGRESS || this == RANDOM || VersionUtils.getVersion().isAtLeast(VersionUtils.Version.V1_9);
    }

    public static BossbarStyleAdapter valueOf(String name) {
        return (BossbarStyleAdapter)BossbarStyleAdapter.valueOf((String)name, (PseudoEnum[])VALUES);
    }

    public static BossbarStyleAdapter[] values() {
        return VALUES;
    }

    public static BossbarStyleAdapter value(String name) {
        name = name.toUpperCase();
        for (BossbarStyleAdapter value : VALUES) {
            if (!value.name().equals(name) && !value.getBukkitID().equals(name)) continue;
            return value;
        }
        return null;
    }

    static {
        if (Environment.isSponge()) {
            spongeStyles = Stream.of({"PROGRESS", BossBarOverlays.PROGRESS}, {"NOTCHED_6", BossBarOverlays.NOTCHED_6}, {"NOTCHED_10", BossBarOverlays.NOTCHED_10}, {"NOTCHED_12", BossBarOverlays.NOTCHED_12}, {"NOTCHED_20", BossBarOverlays.NOTCHED_20}).collect(Collectors.toMap(color -> (String)color[0], color -> color[1], (x, y) -> y, LinkedHashMap::new));
        }
    }
}

