/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.util;

import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import me.remigio07.chatplugin.api.common.player.PlayerManager;
import me.remigio07.chatplugin.api.common.storage.configuration.ConfigurationType;
import me.remigio07.chatplugin.api.common.util.manager.LogManager;
import me.remigio07.chatplugin.api.server.language.Language;
import me.remigio07.chatplugin.api.server.util.DateFormat;
import me.remigio07.chatplugin.bootstrap.Environment;
import me.remigio07.chatplugin.bootstrap.JARLibraryLoader;
import net.minecraft.class_2561;
import org.bukkit.Bukkit;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.world.World;

public class Utils
extends me.remigio07.chatplugin.api.common.util.Utils {
    public static int getOnlineWorld(String world) {
        return (int)(Environment.isBukkit() ? (long)Bukkit.getWorld((String)world).getPlayers().size() : ((World)Sponge.getServer().getWorld(world).get()).getEntities().stream().filter(entity -> entity instanceof Player).count());
    }

    public static String formatDate(long ms, Language language, DateFormat format) {
        try {
            long now = System.currentTimeMillis();
            return new SimpleDateFormat(language.getMessage("misc.simple-date-format." + format.name().toLowerCase(), new Object[0])).format(new Date(ms + (long)PlayerManager.getInstance().getDisplayedTimeZone().getOffset(now) - (long)TimeZone.getDefault().getOffset(now)));
        }
        catch (IllegalArgumentException iae) {
            LogManager.log("Invalid date format specified at \"{0}\" in {1}: {2}", 2, "misc.simple-date-format." + format.name().toLowerCase(), language.getConfiguration().getPath().getFileName().toString(), iae.getLocalizedMessage());
            return "Invalid date format specified at \"misc.simple-date-format.\"" + format.name().toLowerCase();
        }
    }

    public static String formatTime(long totalMilliseconds, Language language, boolean everInsteadOfNever, boolean useZeroSecondsInstead) {
        StringBuilder sb = new StringBuilder();
        long totalSeconds = (totalMilliseconds + 999L) / 1000L;
        if (totalMilliseconds == -1L) {
            return language.getMessage(everInsteadOfNever ? "timestamps.ever" : "timestamps.never", new Object[0]);
        }
        if (totalSeconds < 1L) {
            return useZeroSecondsInstead ? "0" + language.getMessage("timestamps.seconds", new Object[0]) : language.getMessage("timestamps.now", new Object[0]);
        }
        int years = (int)(totalSeconds / 31536000L);
        int months = (int)((totalSeconds -= (long)(years * 31536000)) / 2592000L);
        int days = (int)((totalSeconds -= (long)(months * 2592000)) / 86400L);
        totalSeconds -= (long)(days * 86400);
        int weeks = 0;
        if (ConfigurationType.CONFIG.get().getBoolean("settings.use-week-timestamp")) {
            weeks = (int)(totalSeconds / 604800L);
            totalSeconds -= (long)(weeks * 604800);
        }
        int hours = (int)(totalSeconds / 3600L);
        int minutes = (int)((totalSeconds -= (long)(hours * 3600)) / 60L);
        totalSeconds -= (long)(minutes * 60);
        if (years != 0) {
            sb.append(years + (years == 1 ? "{year}, " : "{years}, "));
        }
        if (months != 0) {
            sb.append(months + (months == 1 ? "{month}, " : "{months}, "));
        }
        if (weeks != 0) {
            sb.append(weeks + (weeks == 1 ? "{week}, " : "{weeks}, "));
        }
        if (days != 0) {
            sb.append(days + (days == 1 ? "{day}, " : "{days}, "));
        }
        if (hours != 0) {
            sb.append(hours + (hours == 1 ? "{hour}, " : "{hours}, "));
        }
        if (minutes != 0) {
            sb.append(minutes + (minutes == 1 ? "{minute}, " : "{minutes}, "));
        }
        if (totalSeconds != 0L || useZeroSecondsInstead && minutes == 0 && hours == 0 && days == 0 && weeks == 0 && months == 0 && years == 0) {
            sb.append(totalSeconds + (totalSeconds == 1L ? "{second}" : "{seconds}"));
        } else {
            sb.delete(sb.length() - 2, sb.length());
        }
        return sb.toString().replace("{second}", language.getMessage("timestamps.second", new Object[0])).replace("{seconds}", language.getMessage("timestamps.seconds", new Object[0])).replace("{minute}", language.getMessage("timestamps.minute", new Object[0])).replace("{minutes}", language.getMessage("timestamps.minutes", new Object[0])).replace("{hour}", language.getMessage("timestamps.hour", new Object[0])).replace("{hours}", language.getMessage("timestamps.hours", new Object[0])).replace("{day}", language.getMessage("timestamps.day", new Object[0])).replace("{days}", language.getMessage("timestamps.days", new Object[0])).replace("{week}", language.getMessage("timestamps.week", new Object[0])).replace("{weeks}", language.getMessage("timestamps.weeks", new Object[0])).replace("{month}", language.getMessage("timestamps.month", new Object[0])).replace("{months}", language.getMessage("timestamps.months", new Object[0])).replace("{year}", language.getMessage("timestamps.year", new Object[0])).replace("{years}", language.getMessage("timestamps.years", new Object[0]));
    }

    public static String toLegacyText(Text spongeComponent) {
        return TextSerializers.LEGACY_FORMATTING_CODE.serialize(spongeComponent);
    }

    public static String toLegacyText(class_2561 fabricComponent) {
        try {
            return (String)Class.forName("me.remigio07.chatplugin.server.fabric.ChatPluginFabric", false, JARLibraryLoader.getInstance()).getMethod("toLegacyText", class_2561.class).invoke(null, fabricComponent);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to call Utils#toLegacyText(Text) as the plugin has not finished loading yet");
        }
    }

    public static Text toSpongeComponent(String legacyText) {
        return TextSerializers.LEGACY_FORMATTING_CODE.deserialize(legacyText);
    }

    public static class_2561 toFabricComponent(String legacyText) {
        try {
            return (class_2561)Class.forName("me.remigio07.chatplugin.server.fabric.ChatPluginFabric", false, JARLibraryLoader.getInstance()).getMethod("toFabricComponent", String.class).invoke(null, legacyText);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to call Utils#toFabricComponent(String) as the plugin has not finished loading yet");
        }
    }
}

