/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.scoreboard;

import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import me.remigio07.chatplugin.api.common.storage.configuration.Configuration;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManager;
import me.remigio07.chatplugin.api.server.scoreboard.Scoreboard;
import me.remigio07.chatplugin.api.server.util.PlaceholderType;

public abstract class ScoreboardManager
implements ChatPluginManager {
    public static final Pattern SCOREBOARD_ID_PATTERN = Pattern.compile("^[a-zA-Z0-9-_]{2,36}$");
    protected static ScoreboardManager instance;
    protected boolean enabled;
    protected List<Scoreboard> scoreboards = new CopyOnWriteArrayList<Scoreboard>();
    protected Timer timer;
    protected long loadTime;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public List<Scoreboard> getScoreboards() {
        return this.scoreboards;
    }

    public void addScoreboard(Scoreboard scoreboard) {
        if (this.scoreboards.stream().anyMatch(other -> other.getID().equalsIgnoreCase(scoreboard.getID()))) {
            throw new IllegalArgumentException("Specified ID (" + scoreboard.getID() + ") is already in use");
        }
        this.scoreboards.add(scoreboard);
    }

    public Scoreboard getScoreboard(String id) {
        return this.scoreboards.stream().filter(scoreboard -> scoreboard.getID().equalsIgnoreCase(id)).findAny().orElse(null);
    }

    public Timer getTimer() {
        return this.timer;
    }

    public boolean isValidScoreboardID(String scoreboardID) {
        return SCOREBOARD_ID_PATTERN.matcher(scoreboardID).matches();
    }

    public static ScoreboardManager getInstance() {
        return instance;
    }

    public abstract Scoreboard.Builder createScoreboardBuilder(String var1, boolean var2, Set<PlaceholderType> var3);

    public abstract Scoreboard createScoreboard(Configuration var1);
}

