/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.scoreboard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import me.remigio07.chatplugin.api.common.util.VersionUtils;
import me.remigio07.chatplugin.api.server.language.Language;
import me.remigio07.chatplugin.api.server.scoreboard.Scoreboard;

public abstract class ScoreboardLines {
    public static final int MAX_LINE_LENGTH = VersionUtils.getVersion().getProtocol() > 340 ? 128 : 32;
    public static final String LINE_TOO_LONG = "\u00a7cLine exceeds \u00a7f" + MAX_LINE_LENGTH + " \u00a7cchars";
    protected Scoreboard scoreboard;
    protected List<ScoreboardLine> lines = new ArrayList<Object>(Collections.nCopies(15, null));

    public Scoreboard getScoreboard() {
        return this.scoreboard;
    }

    public List<ScoreboardLine> getLines() {
        return this.lines;
    }

    public ScoreboardLine getLine(int lineIndex) {
        if (lineIndex < 0 || lineIndex > 14) {
            throw new IndexOutOfBoundsException("Specified line index (" + lineIndex + ") is not inside of range 0 - 14");
        }
        return this.lines.get(lineIndex);
    }

    public static abstract class ScoreboardLine
    extends TimerTask {
        protected ScoreboardLines lines;
        protected Map<Language, List<String>> values = new ConcurrentHashMap<Language, List<String>>();
        protected Map<Language, Integer> timerIndexes = new ConcurrentHashMap<Language, Integer>();
        protected int lineIndex;
        protected boolean randomOrder;
        protected long sendingTimeout;

        public ScoreboardLines getLines() {
            return this.lines;
        }

        public Map<Language, List<String>> getValues() {
            return this.values;
        }

        public List<String> getValues(Language language, boolean avoidNull) {
            return this.values.get(language) == null ? (avoidNull ? this.values.get(Language.getMainLanguage()) : null) : this.values.get(language);
        }

        public Map<Language, Integer> getTimerIndexes() {
            return this.timerIndexes;
        }

        public int getLineIndex() {
            return this.lineIndex;
        }

        public boolean isRandomOrder() {
            return this.randomOrder;
        }

        public long getSendingTimeout() {
            return this.sendingTimeout;
        }

        @Override
        public abstract void run();
    }
}

