/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.rank;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManager;
import me.remigio07.chatplugin.api.server.rank.Rank;

public abstract class RankManager
implements ChatPluginManager {
    public static final Pattern RANK_ID_PATTERN = Pattern.compile("^(?!settings$)[a-zA-Z0-9-_+]{2,36}$");
    protected static RankManager instance;
    protected boolean enabled;
    protected boolean luckPermsMode;
    protected boolean sortingEnabled;
    protected boolean sortingFromTablistTop;
    protected List<Rank> ranks = new ArrayList<Rank>();
    protected long loadTime;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isLuckPermsMode() {
        return this.luckPermsMode;
    }

    public boolean isSortingEnabled() {
        return this.sortingEnabled;
    }

    public boolean isSortingFromTablistTop() {
        return this.sortingFromTablistTop;
    }

    public Rank getDefaultRank() {
        return this.luckPermsMode ? this.getRank("default") : this.ranks.get(0);
    }

    public List<Rank> getRanks() {
        return this.ranks;
    }

    public Rank getRank(String id) {
        return this.ranks.stream().filter(rank -> rank.getID().equalsIgnoreCase(id)).findAny().orElse(null);
    }

    public boolean isValidRankID(String rankID) {
        return RANK_ID_PATTERN.matcher(rankID).matches();
    }

    public static RankManager getInstance() {
        return instance;
    }
}

