/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.player;

import java.net.InetAddress;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.remigio07.chatplugin.api.ChatPlugin;
import me.remigio07.chatplugin.api.common.integration.IntegrationType;
import me.remigio07.chatplugin.api.common.player.PlayerManager;
import me.remigio07.chatplugin.api.common.storage.DataContainer;
import me.remigio07.chatplugin.api.common.storage.StorageConnector;
import me.remigio07.chatplugin.api.common.storage.configuration.ConfigurationType;
import me.remigio07.chatplugin.api.common.util.ChatPluginState;
import me.remigio07.chatplugin.api.common.util.VersionUtils;
import me.remigio07.chatplugin.api.common.util.adapter.user.PlayerAdapter;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManagerException;
import me.remigio07.chatplugin.api.common.util.manager.LogManager;
import me.remigio07.chatplugin.api.common.util.manager.TaskManager;
import me.remigio07.chatplugin.api.server.player.ChatPluginServerPlayer;

public abstract class ServerPlayerManager
extends PlayerManager {
    protected static Map<UUID, VersionUtils.Version> playersVersions = new ConcurrentHashMap<UUID, VersionUtils.Version>();
    protected static Map<UUID, Long> playersLoginTimes = new ConcurrentHashMap<UUID, Long>();
    protected static List<UUID> bedrockPlayers = new CopyOnWriteArrayList<UUID>();
    protected Map<UUID, ChatPluginServerPlayer> players = new ConcurrentHashMap<UUID, ChatPluginServerPlayer>();
    protected List<String> enabledWorlds = Collections.emptyList();
    protected int storageCount;

    @Override
    public void load() throws ChatPluginManagerException {
        try {
            this.storageCount = StorageConnector.getInstance().count(DataContainer.PLAYERS, new StorageConnector.WhereCondition[0]).intValue();
        }
        catch (SQLException sqle) {
            throw new ChatPluginManagerException(this, (Exception)sqle);
        }
        if (IntegrationType.FLOODGATE.isEnabled()) {
            this.floodgateUsernamePrefix = IntegrationType.FLOODGATE.get().getUsernamePrefix();
            if (this.floodgateUsernamePrefix.isEmpty()) {
                LogManager.log("Floodgate is installed but the username prefix set at \"username-prefix\" in its config.yml is empty: this is not recommended as ChatPlugin will not be able to distinguish Java players from Bedrock ones.", 1, new Object[0]);
            } else if (!Pattern.matches("^[^ \\w]$", this.floodgateUsernamePrefix)) {
                throw new ChatPluginManagerException(this, "invalid Floodgate username prefix ({0}) set at \"username-prefix\" in Floodgate's config.yml: it cannot be longer than 1 character and cannot be a letter, a number, a space or an underscore", this.floodgateUsernamePrefix);
            }
        } else {
            this.floodgateUsernamePrefix = ConfigurationType.CONFIG.get().getString("settings.floodgate-username-prefix");
            if (!Pattern.matches("^[^ \\w]?$", this.floodgateUsernamePrefix)) {
                throw new ChatPluginManagerException(this, "invalid Floodgate username prefix ({0}) set at \"settings.floodgate-username-prefix\" in config.yml: it cannot be longer than 1 character and cannot be a letter, a number, a space or an underscore", this.floodgateUsernamePrefix);
            }
        }
        super.load();
        this.enabledWorlds = new ArrayList<String>(ConfigurationType.CONFIG.get().getStringList("settings.enabled-worlds"));
    }

    @Override
    public void unload() {
        this.enabled = false;
        this.players.keySet().forEach(this::unloadPlayer);
        this.players.clear();
        this.enabledWorlds.clear();
        super.unload();
        this.storageCount = 0;
    }

    public Map<UUID, ChatPluginServerPlayer> getPlayers() {
        return this.players;
    }

    public List<ChatPluginServerPlayer> getPlayers(InetAddress ipAddress) {
        return this.players.values().stream().filter(player -> player.getIPAddress().equals(ipAddress)).collect(Collectors.toList());
    }

    @Override
    public ChatPluginServerPlayer getPlayer(UUID uuid) {
        return this.players.get(uuid);
    }

    @Override
    @Deprecated
    public ChatPluginServerPlayer getPlayer(String name, boolean checkPattern, boolean ignoreCase) {
        if (checkPattern && !this.isValidUsername(name)) {
            throw new IllegalArgumentException("Username \"" + name + "\" does not respect the following pattern: \"" + this.usernamePattern.pattern() + "\"");
        }
        for (ChatPluginServerPlayer player : this.players.values()) {
            if (!(ignoreCase ? player.getName().equalsIgnoreCase(name) : player.getName().equals(name))) continue;
            return player;
        }
        return null;
    }

    public List<String> getEnabledWorlds() {
        return this.enabledWorlds;
    }

    public boolean isWorldEnabled(String world) {
        return this.enabledWorlds.contains("*") || this.enabledWorlds.contains(world) || ConfigurationType.CONFIG.get().getBoolean("settings.enable-every-world");
    }

    public int getStorageCount() {
        return this.storageCount;
    }

    public void setStorageCount(int storageCount) {
        this.storageCount = storageCount;
    }

    protected void verifyAndRun(Runnable runnable) {
        if (ChatPlugin.getState() == ChatPluginState.RELOADING || ChatPlugin.getState() == ChatPluginState.UNLOADING) {
            runnable.run();
        } else {
            TaskManager.runAsync(runnable, 0L);
        }
    }

    public static Map<UUID, VersionUtils.Version> getPlayersVersions() {
        return playersVersions;
    }

    public static VersionUtils.Version getPlayerVersion(UUID player) {
        return playersVersions.get(player);
    }

    public static Map<UUID, Long> getPlayersLoginTimes() {
        return playersLoginTimes;
    }

    public static Long getPlayerLoginTime(UUID player) {
        return playersLoginTimes.get(player);
    }

    public static List<UUID> getBedrockPlayers() {
        return bedrockPlayers;
    }

    public static boolean isBedrockPlayer(UUID player) {
        return bedrockPlayers.contains(player);
    }

    public static ServerPlayerManager getInstance() {
        return (ServerPlayerManager)instance;
    }

    public abstract int loadPlayer(PlayerAdapter var1);

    public abstract int unloadPlayer(UUID var1);
}

