/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.language;

import java.util.List;
import java.util.stream.Collectors;
import me.remigio07.chatplugin.api.common.storage.configuration.Configuration;
import me.remigio07.chatplugin.api.common.storage.configuration.ConfigurationType;
import me.remigio07.chatplugin.api.common.util.Utils;
import me.remigio07.chatplugin.api.server.language.LanguageManager;
import me.remigio07.chatplugin.api.server.player.ChatPluginServerPlayer;
import me.remigio07.chatplugin.api.server.player.ServerPlayerManager;

public abstract class Language {
    protected String id;
    protected String displayName;
    protected List<String> countryCodes;
    protected Configuration configuration;

    protected Language(String id, String displayName, List<String> countryCodes) {
        this.id = id;
        this.displayName = displayName;
        this.countryCodes = countryCodes;
    }

    public String getID() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<String> getCountryCodes() {
        return this.countryCodes;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String getMessage(String path, Object ... args) {
        return Utils.replaceNumericPlaceholders(this.configuration.translateString(path, ConfigurationType.MESSAGES.get().translateString(path)).replace("{pfx}", this.configuration.translateString("misc.prefix", ConfigurationType.MESSAGES.get().translateString("misc.prefix"))), args);
    }

    public List<ChatPluginServerPlayer> getOnlinePlayers() {
        return ServerPlayerManager.getInstance().getPlayers().values().stream().filter(player -> player.getLanguage().equals(this)).collect(Collectors.toList());
    }

    public static Language getMainLanguage() {
        return LanguageManager.getInstance().getMainLanguage();
    }
}

