/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.join_quit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.remigio07.chatplugin.api.common.player.OfflinePlayer;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManager;
import me.remigio07.chatplugin.api.server.language.Language;
import me.remigio07.chatplugin.api.server.rank.Rank;
import me.remigio07.chatplugin.api.server.rank.RankManager;

public abstract class QuitMessageManager
implements ChatPluginManager {
    protected static QuitMessageManager instance;
    protected boolean enabled;
    protected Map<Rank, Map<Language, List<String>>> quitMessages = new HashMap<Rank, Map<Language, List<String>>>();
    protected Map<UUID, QuitPacket> quitPackets = new HashMap<UUID, QuitPacket>();
    protected List<UUID> fakeQuits = new ArrayList<UUID>();
    protected long loadTime;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public Map<Rank, Map<Language, List<String>>> getQuitMessages() {
        return this.quitMessages;
    }

    public List<String> getQuitMessages(Rank rank, Language language) {
        Rank otherRank = this.quitMessages.get(rank) == null ? RankManager.getInstance().getDefaultRank() : rank;
        return this.quitMessages.get(otherRank).get(this.quitMessages.get(otherRank).get(language) == null ? Language.getMainLanguage() : language);
    }

    public Map<UUID, QuitPacket> getQuitPackets() {
        return this.quitPackets;
    }

    public List<UUID> getFakeQuits() {
        return this.fakeQuits;
    }

    public boolean hasFakeQuit(UUID player) {
        return this.fakeQuits.contains(player);
    }

    public static QuitMessageManager getInstance() {
        return instance;
    }

    public abstract String getQuitMessage(QuitPacket var1, Language var2);

    public abstract void sendQuitMessage(QuitPacket var1);

    public static abstract class QuitPacket {
        public static final String[] PLACEHOLDERS = new String[]{"pfx", "player", "uuid", "display_name", "player_id", "rank_id", "rank_display_name", "prefix", "suffix", "tag_prefix", "tag_suffix", "tag_name_color", "chat_color", "rank_position", "rank_description", "max_ban_duration", "max_mute_duration"};
        protected OfflinePlayer player;
        protected String displayName;
        protected Rank rank;
        protected int playerID;
        protected boolean vanished;

        public OfflinePlayer getPlayer() {
            return this.player;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Rank getRank() {
            return this.rank;
        }

        public int getPlayerID() {
            return this.playerID;
        }

        public boolean isVanished() {
            return this.vanished;
        }

        public abstract String formatPlaceholders(String var1, Language var2);

        public abstract List<String> formatPlaceholders(List<String> var1, Language var2);
    }
}

