/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.integration.anticheat;

import java.util.List;
import me.remigio07.chatplugin.api.common.integration.IntegrationType;
import me.remigio07.chatplugin.api.common.player.OfflinePlayer;
import me.remigio07.chatplugin.api.common.storage.configuration.ConfigurationType;
import me.remigio07.chatplugin.api.common.util.VersionUtils;
import me.remigio07.chatplugin.api.server.integration.anticheat.AnticheatIntegration;
import me.remigio07.chatplugin.api.server.language.Language;

public abstract class Violation {
    public static final String[] PLACEHOLDERS = new String[]{"cheater", "cheater_uuid", "anticheat", "cheat_id", "cheat_display_name", "component", "server", "amount", "ping", "ping_format", "tps", "version", "version_protocol", "client_edition", "last_time"};
    protected OfflinePlayer cheater;
    protected IntegrationType<AnticheatIntegration> anticheat;
    protected String cheatID;
    protected String component;
    protected String server;
    protected int amount;
    protected int ping;
    protected double tps;
    protected VersionUtils.Version version;
    protected boolean bedrockEdition;
    protected long lastTime = System.currentTimeMillis();

    protected Violation(OfflinePlayer cheater, IntegrationType<AnticheatIntegration> anticheat, String cheatID, VersionUtils.Version version, boolean bedrockEdition) {
        this.cheater = cheater;
        this.anticheat = anticheat;
        this.cheatID = cheatID;
        this.version = version;
        this.bedrockEdition = bedrockEdition;
    }

    public OfflinePlayer getCheater() {
        return this.cheater;
    }

    public IntegrationType<AnticheatIntegration> getAnticheat() {
        return this.anticheat;
    }

    public String getCheatID() {
        return this.cheatID;
    }

    public String getCheatDisplayName() {
        return ConfigurationType.VIOLATIONS_ICONS.get().translateString(this.anticheat.name().toLowerCase() + "." + this.cheatID.toLowerCase() + ".name");
    }

    public String getComponent() {
        return this.component;
    }

    public String getServer() {
        return this.server;
    }

    public int getAmount() {
        return this.amount;
    }

    public int getPing() {
        return this.ping;
    }

    public double getTPS() {
        return this.tps;
    }

    public VersionUtils.Version getVersion() {
        return this.version;
    }

    public boolean isBedrockPlayer() {
        return this.bedrockEdition;
    }

    public long getLastTime() {
        return this.lastTime;
    }

    public abstract String formatPlaceholders(String var1, Language var2);

    public abstract List<String> formatPlaceholders(List<String> var1, Language var2);
}

