/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.integration.anticheat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.remigio07.chatplugin.api.common.integration.IntegrationManager;
import me.remigio07.chatplugin.api.common.integration.IntegrationType;
import me.remigio07.chatplugin.api.common.player.OfflinePlayer;
import me.remigio07.chatplugin.api.common.util.VersionUtils;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManager;
import me.remigio07.chatplugin.api.server.integration.anticheat.AnticheatIntegration;
import me.remigio07.chatplugin.api.server.integration.anticheat.Violation;

public abstract class AnticheatManager
implements ChatPluginManager {
    protected static AnticheatManager instance;
    protected Map<OfflinePlayer, List<Violation>> violations = new ConcurrentHashMap<OfflinePlayer, List<Violation>>();
    protected List<String> reasonsStartWith = new ArrayList<String>();
    protected long violationsExpirationTimeout = -1L;
    protected long loadTime;

    @Override
    public boolean isEnabled() {
        return IntegrationManager.getInstance().isAtLeastOneAnticheatEnabled();
    }

    public Map<OfflinePlayer, List<Violation>> getViolations() {
        return this.violations;
    }

    public List<Violation> getViolations(OfflinePlayer player) {
        return this.violations.getOrDefault(player, Collections.emptyList());
    }

    public List<String> getReasonsStartWith() {
        return this.reasonsStartWith;
    }

    public long getViolationsExpirationTimeout() {
        return this.violationsExpirationTimeout;
    }

    public static AnticheatManager getInstance() {
        return instance;
    }

    public abstract void addViolation(OfflinePlayer var1, IntegrationType<AnticheatIntegration> var2, String var3, String var4, String var5, int var6, int var7, double var8, VersionUtils.Version var10, boolean var11);

    public abstract void removeViolation(OfflinePlayer var1, IntegrationType<AnticheatIntegration> var2, String var3);

    public abstract void clearViolations(OfflinePlayer var1);

    public abstract boolean isAnticheatReason(String var1);
}

