/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.gui;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import me.remigio07.chatplugin.api.server.gui.GUI;
import me.remigio07.chatplugin.api.server.gui.GUILayout;
import me.remigio07.chatplugin.api.server.gui.SinglePageGUILayout;
import me.remigio07.chatplugin.api.server.language.Language;
import me.remigio07.chatplugin.api.server.player.ChatPluginServerPlayer;
import me.remigio07.chatplugin.api.server.util.adapter.inventory.ClickEventAdapter;
import me.remigio07.chatplugin.api.server.util.adapter.inventory.DragEventAdapter;
import me.remigio07.chatplugin.api.server.util.adapter.inventory.InventoryAdapter;
import me.remigio07.chatplugin.api.server.util.manager.PlaceholderManager;

public abstract class SinglePageGUI
extends GUI {
    protected List<ChatPluginServerPlayer> viewers = new CopyOnWriteArrayList<ChatPluginServerPlayer>();
    protected Map<Language, InventoryAdapter> inventories = new ConcurrentHashMap<Language, InventoryAdapter>();
    protected BiFunction<String, Language, String> titlesTranslator;

    protected SinglePageGUI(GUILayout layout) {
        super(layout);
    }

    @Override
    public SinglePageGUILayout getLayout() {
        return (SinglePageGUILayout)this.layout;
    }

    public List<ChatPluginServerPlayer> getViewers() {
        return this.viewers;
    }

    public Map<Language, InventoryAdapter> getInventories() {
        return this.inventories;
    }

    public InventoryAdapter getInventory(Language language) {
        return this.inventories.get(language);
    }

    public BiFunction<String, Language, String> getTitlesTranslator() {
        return this.titlesTranslator;
    }

    public SinglePageGUI setTitlesTranslator(BiFunction<String, Language, String> titlesTranslator) {
        this.titlesTranslator = titlesTranslator;
        return this;
    }

    public SinglePageGUI setServerTitlesTranslator() {
        this.titlesTranslator = (t, u) -> PlaceholderManager.getInstance().translateServerPlaceholders((String)t, (Language)u);
        return this;
    }

    public abstract boolean open(ChatPluginServerPlayer var1, boolean var2);

    public abstract boolean handleClickEvent(ChatPluginServerPlayer var1, ClickEventAdapter var2);

    public abstract boolean handleDragEvent(ChatPluginServerPlayer var1, DragEventAdapter var2);

    public abstract String getTitle(Language var1);
}

