/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.gui;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import me.remigio07.chatplugin.api.common.storage.configuration.Configuration;
import me.remigio07.chatplugin.api.common.util.text.ChatColor;
import me.remigio07.chatplugin.api.server.gui.FillableGUI;
import me.remigio07.chatplugin.api.server.gui.GUI;
import me.remigio07.chatplugin.api.server.gui.SinglePageGUI;
import me.remigio07.chatplugin.api.server.language.Language;
import me.remigio07.chatplugin.api.server.language.LanguageManager;
import me.remigio07.chatplugin.api.server.player.ChatPluginServerPlayer;
import me.remigio07.chatplugin.api.server.util.adapter.user.SoundAdapter;

public class OpenActions {
    private Map<Language, String> messages;
    private SoundAdapter sound;

    public OpenActions(Map<Language, String> messages, SoundAdapter sound) {
        if (messages.get(Language.getMainLanguage()) == null) {
            throw new NoSuchElementException("Specified open actions' map does not contain a translation for the main language");
        }
        this.messages = messages;
        this.sound = sound;
    }

    public OpenActions(Configuration configuration) {
        this(LanguageManager.getInstance().getLanguages().stream().collect(HashMap::new, (map, language) -> map.put(language, configuration.getString("settings.open-actions.send-messages." + language.getID(), null)), HashMap::putAll), new SoundAdapter(configuration, "settings.open-actions.play-sound"));
    }

    public Map<Language, String> getMessages() {
        return this.messages;
    }

    public String getMessage(Language language, boolean avoidNull) {
        return this.messages.get(language) == null ? (avoidNull ? this.messages.get(Language.getMainLanguage()) : null) : this.messages.get(language);
    }

    public SoundAdapter getSound() {
        return this.sound;
    }

    public void perform(ChatPluginServerPlayer player, GUI gui) {
        player.playSound(this.sound);
        player.sendMessage(ChatColor.translate(this.getMessage(player.getLanguage(), true).replace("{pfx}", player.getLanguage().getMessage("misc.prefix", new Object[0])).replace("{0}", gui instanceof SinglePageGUI ? ((SinglePageGUI)gui).getTitle(player.getLanguage()) : ((FillableGUI)gui).getTitle(player.getLanguage(), ((FillableGUI)gui).getViewers().get(player)))));
    }
}

