/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.gui;

import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import me.remigio07.chatplugin.api.common.storage.configuration.Configuration;
import me.remigio07.chatplugin.api.common.util.ValueContainer;
import me.remigio07.chatplugin.api.server.gui.GUIManager;
import me.remigio07.chatplugin.api.server.gui.Icon;
import me.remigio07.chatplugin.api.server.language.Language;
import me.remigio07.chatplugin.api.server.util.adapter.block.MaterialAdapter;
import me.remigio07.chatplugin.api.server.util.adapter.inventory.item.EnchantmentAdapter;
import me.remigio07.chatplugin.api.server.util.adapter.inventory.item.ItemFlagAdapter;

public class IconLayout {
    public static final IconLayout EMPTY_ICON_LAYOUT = new IconLayout("empty-icon-layout", MaterialAdapter.AIR, true, false, new ValueContainer<Short>((short)0), 0);
    private String id;
    private String skullOwner;
    private String skullTextureURL;
    private String permission;
    private MaterialAdapter material;
    private ValueContainer<Short> amount;
    private short damage;
    private boolean keepOpen;
    private boolean glowing;
    private Color leatherArmorColor;
    private List<String> commands;
    private List<ItemFlagAdapter> itemFlags;
    private Map<Language, String> displayNames;
    private Map<Language, List<String>> lores;
    private Map<EnchantmentAdapter, Integer> enchantments;

    public IconLayout(Configuration configuration, String path) {
        Icon icon = GUIManager.getInstance().createIcon(configuration, path);
        this.id = icon.getID();
        this.material = icon.getMaterial();
        this.amount = icon.getAmount();
        this.damage = icon.getDamage();
        this.keepOpen = icon.isKeepOpen();
        this.glowing = icon.isGlowing();
        this.skullOwner = icon.getSkullOwner();
        this.skullTextureURL = icon.getSkullTextureURL();
        this.leatherArmorColor = icon.getLeatherArmorColor();
        this.permission = icon.getPermission();
        this.commands = icon.getCommands();
        this.itemFlags = icon.getItemFlags();
        this.displayNames = icon.getDisplayNames();
        this.lores = icon.getLores();
        this.enchantments = icon.getEnchantments();
    }

    public IconLayout(String id, MaterialAdapter material, boolean keepOpen, boolean glowing, ValueContainer<Short> amount, short damage) {
        this(id, material, amount, damage, keepOpen, glowing, null, null, null, null, new CopyOnWriteArrayList<String>(), new CopyOnWriteArrayList<ItemFlagAdapter>(), new ConcurrentHashMap<Language, String>(), new ConcurrentHashMap<Language, List<String>>(), new ConcurrentHashMap<EnchantmentAdapter, Integer>());
    }

    public IconLayout(String id, MaterialAdapter material, ValueContainer<Short> amount, short damage, boolean keepOpen, boolean glowing, String skullOwner, String skullTextureURL, Color leatherArmorColor, String permission, List<String> commands, List<ItemFlagAdapter> itemFlags, Map<Language, String> displayNames, Map<Language, List<String>> lores, Map<EnchantmentAdapter, Integer> enchantments) {
        this.id = id;
        this.material = material;
        this.amount = amount;
        this.damage = damage;
        this.keepOpen = keepOpen;
        this.glowing = glowing;
        this.skullOwner = skullOwner;
        this.skullTextureURL = skullTextureURL;
        this.leatherArmorColor = leatherArmorColor;
        this.permission = permission;
        this.commands = commands;
        this.itemFlags = itemFlags;
        this.displayNames = displayNames;
        this.lores = lores;
        this.enchantments = enchantments;
    }

    public String getID() {
        return this.id;
    }

    public MaterialAdapter getMaterial() {
        return this.material;
    }

    public IconLayout setMaterial(MaterialAdapter material) {
        this.material = material;
        return this;
    }

    public ValueContainer<Short> getAmount() {
        return this.amount;
    }

    public IconLayout setAmount(ValueContainer<Short> amount) {
        this.amount = amount.placeholder() == null ? (amount.value() < 1 ? new ValueContainer((short)1) : ((Short)amount.value() > 64 ? new ValueContainer((short)64) : amount)) : amount;
        return this;
    }

    public short getDamage() {
        return this.damage;
    }

    public IconLayout setDamage(short damage) {
        this.damage = damage < 0 ? (short)0 : damage;
        return this;
    }

    public boolean isKeepOpen() {
        return this.keepOpen;
    }

    public IconLayout setKeepOpen(boolean keepOpen) {
        this.keepOpen = keepOpen;
        return this;
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    public IconLayout setGlowing(boolean glowing) {
        this.glowing = glowing;
        return this;
    }

    public String getSkullOwner() {
        return this.skullOwner;
    }

    public IconLayout setSkullOwner(String skullOwner) {
        this.skullOwner = skullOwner;
        return this;
    }

    public String getSkullTextureURL() {
        return this.skullTextureURL;
    }

    public IconLayout setSkullTextureURL(String skullTextureURL) {
        this.skullTextureURL = skullTextureURL;
        return this;
    }

    public Color getLeatherArmorColor() {
        return this.leatherArmorColor;
    }

    public IconLayout setLeatherArmorColor(Color leatherArmorColor) {
        this.leatherArmorColor = leatherArmorColor;
        return this;
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public List<ItemFlagAdapter> getItemFlags() {
        return this.itemFlags;
    }

    public Map<Language, String> getDisplayNames() {
        return this.displayNames;
    }

    public Map<Language, List<String>> getLores() {
        return this.lores;
    }

    public Map<EnchantmentAdapter, Integer> getEnchantments() {
        return this.enchantments;
    }
}

