/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.gui;

import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.remigio07.chatplugin.api.common.util.ValueContainer;
import me.remigio07.chatplugin.api.common.util.text.ChatColor;
import me.remigio07.chatplugin.api.server.gui.GUI;
import me.remigio07.chatplugin.api.server.gui.IconType;
import me.remigio07.chatplugin.api.server.language.Language;
import me.remigio07.chatplugin.api.server.util.adapter.block.MaterialAdapter;
import me.remigio07.chatplugin.api.server.util.adapter.inventory.item.EnchantmentAdapter;
import me.remigio07.chatplugin.api.server.util.adapter.inventory.item.ItemFlagAdapter;
import me.remigio07.chatplugin.api.server.util.adapter.inventory.item.ItemStackAdapter;

public class Icon {
    public static final Pattern ICON_ID_PATTERN = Pattern.compile("^[a-zA-Z0-9-_]{2,36}$");
    private String id;
    private String skullOwner;
    private String skullTextureURL;
    private String permission;
    private IconType type;
    private MaterialAdapter material;
    private ValueContainer<Short> amount;
    private short damage;
    private boolean keepOpen;
    private boolean glowing;
    private int position;
    private Color leatherArmorColor;
    private List<String> commands;
    private List<ItemFlagAdapter> itemFlags;
    private Map<Language, String> displayNames;
    private Map<Language, List<String>> lores;
    private Map<EnchantmentAdapter, Integer> enchantments;

    public Icon(Icon icon) {
        this(icon.getID(), icon.getType(), icon.getMaterial(), icon.getAmount(), icon.getDamage(), icon.isKeepOpen(), icon.isGlowing(), icon.getPosition(), icon.getSkullOwner(), icon.getSkullTextureURL(), icon.getLeatherArmorColor(), icon.getPermission(), icon.getCommands(), icon.getItemFlags(), icon.getDisplayNames(), icon.getLores(), icon.getEnchantments());
    }

    public Icon(String id, IconType type, MaterialAdapter material, ValueContainer<Short> amount, short damage, boolean keepOpen, boolean glowing, int position) {
        this(id, type, material, amount, damage, keepOpen, glowing, position, null, null, null, null, new CopyOnWriteArrayList<String>(), new CopyOnWriteArrayList<ItemFlagAdapter>(), new ConcurrentHashMap<Language, String>(), new ConcurrentHashMap<Language, List<String>>(), new ConcurrentHashMap<EnchantmentAdapter, Integer>());
    }

    public Icon(String id, IconType type, MaterialAdapter material, ValueContainer<Short> amount, short damage, boolean keepOpen, boolean glowing, int position, String skullOwner, String skullTextureURL, Color leatherArmorColor, String permission, List<String> commands, List<ItemFlagAdapter> itemFlags, Map<Language, String> displayNames, Map<Language, List<String>> lores, Map<EnchantmentAdapter, Integer> enchantments) {
        if (!Icon.isValidIconID(id)) {
            throw new IllegalArgumentException("Icon ID \"" + id + "\" does not respect the following pattern: \"" + ICON_ID_PATTERN.pattern() + "\"");
        }
        this.id = id;
        this.type = type;
        this.material = material;
        this.amount = amount;
        this.damage = damage;
        this.keepOpen = keepOpen;
        this.glowing = glowing;
        this.position = position;
        this.skullOwner = skullOwner;
        this.skullTextureURL = skullTextureURL;
        this.leatherArmorColor = leatherArmorColor;
        this.permission = permission;
        this.commands = commands;
        this.itemFlags = itemFlags;
        this.displayNames = displayNames;
        this.lores = lores;
        this.enchantments = enchantments;
    }

    public String getID() {
        return this.id;
    }

    public IconType getType() {
        return this.type;
    }

    public MaterialAdapter getMaterial() {
        return this.material;
    }

    public Icon setMaterial(MaterialAdapter material) {
        this.material = material;
        return this;
    }

    public ValueContainer<Short> getAmount() {
        return this.amount;
    }

    public Icon setAmount(ValueContainer<Short> amount) {
        this.amount = amount.placeholder() == null ? (amount.value() < 1 ? new ValueContainer((short)1) : ((Short)amount.value() > 64 ? new ValueContainer((short)64) : amount)) : amount;
        return this;
    }

    public short getDamage() {
        return this.damage;
    }

    public Icon setDamage(short damage) {
        this.damage = damage < 0 ? (short)0 : damage;
        return this;
    }

    public boolean isKeepOpen() {
        return this.keepOpen;
    }

    public Icon setKeepOpen(boolean keepOpen) {
        this.keepOpen = keepOpen;
        return this;
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    public Icon setGlowing(boolean glowing) {
        this.glowing = glowing;
        return this;
    }

    public int getPosition() {
        return this.position;
    }

    public Icon setPosition(int position) {
        this.position = position < 0 ? 0 : position;
        return this;
    }

    public String getSkullOwner() {
        return this.skullOwner;
    }

    public Icon setSkullOwner(String skullOwner) {
        this.skullOwner = skullOwner;
        return this;
    }

    public String getSkullTextureURL() {
        return this.skullTextureURL;
    }

    public Icon setSkullTextureURL(String skullTextureURL) {
        this.skullTextureURL = skullTextureURL;
        return this;
    }

    public Color getLeatherArmorColor() {
        return this.leatherArmorColor;
    }

    public Icon setLeatherArmorColor(Color leatherArmorColor) {
        this.leatherArmorColor = leatherArmorColor;
        return this;
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public Icon setCommands(List<String> commands) {
        this.commands = commands;
        return this;
    }

    public List<ItemFlagAdapter> getItemFlags() {
        return this.itemFlags;
    }

    public Icon setItemFlags(List<ItemFlagAdapter> itemFlags) {
        this.itemFlags = itemFlags;
        return this;
    }

    public Map<Language, String> getDisplayNames() {
        return this.displayNames;
    }

    public Icon setDisplayNames(Map<Language, String> displayNames) {
        this.displayNames = displayNames;
        return this;
    }

    public Map<Language, List<String>> getLores() {
        return this.lores;
    }

    public Icon setLores(Map<Language, List<String>> lores) {
        this.lores = lores;
        return this;
    }

    public Map<EnchantmentAdapter, Integer> getEnchantments() {
        return this.enchantments;
    }

    public Icon setEnchantments(Map<EnchantmentAdapter, Integer> enchantments) {
        this.enchantments = enchantments;
        return this;
    }

    public ItemStackAdapter toItemStackAdapter(GUI gui, Language language) {
        short amount;
        if (this.amount.value() == null) {
            try {
                amount = Short.valueOf(this.formatPlaceholders(this.amount.placeholder(), gui, language, false));
            }
            catch (NumberFormatException e) {
                amount = 1;
            }
        } else {
            amount = this.amount.value();
        }
        ItemStackAdapter itemStack = new ItemStackAdapter(this.material, amount, this.damage).setDisplayName(this.displayNames.get(language) == null ? null : this.formatPlaceholders(this.displayNames.get(language), gui, language, true)).setLore(this.lores.get(language) == null ? null : this.formatPlaceholders(this.lores.get(language), gui, language, true)).setLeatherArmorColor(this.leatherArmorColor).setSkullTextureURL(this.skullTextureURL == null ? null : this.formatPlaceholders(this.skullTextureURL, gui, language, false)).addItemFlags(this.itemFlags.toArray(new ItemFlagAdapter[0]));
        if (this.glowing) {
            itemStack.setGlowing();
        }
        this.enchantments.forEach(itemStack::enchant);
        return itemStack;
    }

    public CompletableFuture<ItemStackAdapter> updateSkullOwner(ItemStackAdapter itemStack, GUI gui, Language language) {
        CompletableFuture<ItemStackAdapter> future = new CompletableFuture<ItemStackAdapter>();
        try {
            itemStack.setSkullOwner(this.skullOwner == null ? null : this.formatPlaceholders(this.skullOwner, gui, language, false), true).thenAccept(future::complete);
        }
        catch (IllegalArgumentException e) {
            future.complete(itemStack);
        }
        return future;
    }

    public String formatPlaceholders(String input, GUI gui, Language language, boolean translateColors) {
        return translateColors ? ChatColor.translate(gui.getStringPlaceholdersTranslator() == null ? input : gui.getStringPlaceholdersTranslator().apply(input, language, this)) : (gui.getStringPlaceholdersTranslator() == null ? input : gui.getStringPlaceholdersTranslator().apply(input, language, this));
    }

    public List<String> formatPlaceholders(List<String> input, GUI gui, Language language, boolean translateColors) {
        return gui.getStringListPlaceholdersTranslator() == null ? input.stream().map(str -> this.formatPlaceholders((String)str, gui, language, translateColors)).collect(Collectors.toList()) : (translateColors ? ChatColor.translate(gui.getStringListPlaceholdersTranslator().apply(input, language, this)) : gui.getStringListPlaceholdersTranslator().apply(input, language, this));
    }

    public static boolean isValidIconID(String iconID) {
        return ICON_ID_PATTERN.matcher(iconID).matches();
    }

    public static int calcIconPosition(int x, int y) {
        return ((y < 1 ? 1 : (y > 6 ? 6 : y)) - 1) * 9 + ((x < 1 ? 1 : (x > 9 ? 9 : x)) - 1);
    }

    public static int[] calcIconCoords(int position) {
        position = position < 0 ? 0 : (position > 53 ? 53 : position);
        int y = position / 9 + 1;
        return new int[]{position - 9 * (y - 1) + 1, y};
    }
}

