/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.gui;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import me.remigio07.chatplugin.api.common.storage.configuration.Configuration;
import me.remigio07.chatplugin.api.server.gui.GUIManager;
import me.remigio07.chatplugin.api.server.gui.Icon;
import me.remigio07.chatplugin.api.server.gui.OpenActions;
import me.remigio07.chatplugin.api.server.language.Language;
import me.remigio07.chatplugin.api.server.language.LanguageManager;
import me.remigio07.chatplugin.api.server.util.adapter.user.SoundAdapter;

public class GUILayout {
    protected String id;
    protected int rows;
    protected Configuration configuration;
    protected OpenActions openActions;
    protected SoundAdapter clickSound;
    protected Map<Language, String> titles;
    protected List<Icon> icons;

    protected GUILayout(String id, int rows, OpenActions openActions, SoundAdapter clickSound, Map<Language, String> titles) {
        if (!GUIManager.getInstance().isValidGUIID(id)) {
            throw new IllegalArgumentException("GUI ID \"" + id + "\" does not respect the following pattern: \"" + GUIManager.GUI_ID_PATTERN.pattern() + "\"");
        }
        if (rows < 1 || rows > 6) {
            throw new IndexOutOfBoundsException("Specified GUI's rows (" + rows + ") are not inside of range 1-6");
        }
        if (titles.get(Language.getMainLanguage()) == null) {
            throw new IllegalArgumentException("Specified titles' map does not contain a translation for the main language");
        }
        this.id = id;
        this.rows = rows;
        this.openActions = openActions;
        this.clickSound = clickSound;
        this.titles = titles;
        this.icons = new CopyOnWriteArrayList<Object>(Collections.nCopies(this.getSize(), null));
    }

    protected GUILayout(Configuration configuration) {
        this(configuration.getPath().getFileName().toString().substring(0, configuration.getPath().getFileName().toString().lastIndexOf(46)), configuration.getInt("settings.rows"), new OpenActions(configuration), new SoundAdapter(configuration, "settings.click-sound"), LanguageManager.getInstance().getLanguages().stream().collect(ConcurrentHashMap::new, (map, language) -> map.put(language, configuration.getString("settings.titles." + language.getID(), null)), ConcurrentHashMap::putAll));
        this.configuration = configuration;
    }

    public String getID() {
        return this.id;
    }

    public int getRows() {
        return this.rows;
    }

    public int getSize() {
        return this.rows * 9;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public OpenActions getOpenActions() {
        return this.openActions;
    }

    public SoundAdapter getClickSound() {
        return this.clickSound;
    }

    public Map<Language, String> getTitles() {
        return this.titles;
    }

    public String getTitle(Language language, boolean avoidNull) {
        return this.titles.get(language) == null ? (avoidNull ? this.titles.get(Language.getMainLanguage()) : null) : this.titles.get(language);
    }

    public List<Icon> getIcons() {
        return this.icons;
    }

    public static abstract class Builder {
        protected GUILayout layout;

        public Builder setIcon(Icon icon) {
            for (Icon otherIcon : this.layout.getIcons()) {
                if (otherIcon == null || !otherIcon.getID().equals(icon.getID()) || otherIcon.getPosition() == icon.getPosition()) continue;
                throw new IllegalArgumentException("Icon's ID (" + icon.getID() + ") is already in use by icon at position " + otherIcon.getPosition());
            }
            try {
                this.layout.getIcons().set(icon.getPosition(), icon);
            }
            catch (IndexOutOfBoundsException e) {
                throw new IndexOutOfBoundsException("Icon's position (" + icon.getPosition() + ") is outside of range 0 - " + (this.layout.getSize() - 1));
            }
            return this;
        }

        public Builder removeIcon(int position) {
            try {
                this.layout.getIcons().set(position, null);
            }
            catch (IndexOutOfBoundsException e) {
                throw new IndexOutOfBoundsException("Icon's position (" + position + ") is outside of range 0 - " + (this.layout.getSize() - 1));
            }
            return this;
        }
    }
}

