/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.gui;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import me.remigio07.chatplugin.api.common.util.TriFunction;
import me.remigio07.chatplugin.api.server.event.gui.GUIRefreshEndEvent;
import me.remigio07.chatplugin.api.server.event.gui.GUIRefreshStartEvent;
import me.remigio07.chatplugin.api.server.gui.GUILayout;
import me.remigio07.chatplugin.api.server.gui.GUIManager;
import me.remigio07.chatplugin.api.server.gui.Icon;
import me.remigio07.chatplugin.api.server.language.Language;
import me.remigio07.chatplugin.api.server.util.adapter.inventory.item.ItemStackAdapter;
import me.remigio07.chatplugin.api.server.util.manager.PlaceholderManager;

public abstract class GUI {
    protected String id;
    protected boolean loaded;
    protected GUILayout layout;
    protected List<CompletableFuture<ItemStackAdapter>> skullOwnerFutures = new CopyOnWriteArrayList<CompletableFuture<ItemStackAdapter>>();
    private TriFunction<String, Language, Icon, String> stringPlaceholdersTranslator;
    private TriFunction<List<String>, Language, Icon, List<String>> stringListPlaceholdersTranslator;

    protected GUI(GUILayout layout) {
        this.id = layout.getID();
        this.layout = layout;
    }

    public synchronized String getID() {
        return this.id;
    }

    public synchronized GUI setID(String id) {
        if (!GUIManager.getInstance().isValidGUIID(id)) {
            throw new IllegalArgumentException("GUI ID \"" + id + "\" does not respect the following pattern: \"" + GUIManager.GUI_ID_PATTERN.pattern() + "\"");
        }
        if (GUIManager.getInstance().getGUIs().contains(this) && GUIManager.getInstance().getGUI(id) != null) {
            throw new IllegalArgumentException("Specified ID (\"" + id + "\") is already in use");
        }
        this.id = id;
        return this;
    }

    public synchronized boolean isLoaded() {
        return this.loaded;
    }

    public GUILayout getLayout() {
        return this.layout;
    }

    public synchronized int refresh() {
        GUIRefreshStartEvent event = new GUIRefreshStartEvent(this);
        event.call();
        if (event.isCancelled()) {
            return -1;
        }
        if (this.isLoaded()) {
            int ms = this.load();
            new GUIRefreshEndEvent(this, ms).call();
            return ms;
        }
        return 0;
    }

    public TriFunction<String, Language, Icon, String> getStringPlaceholdersTranslator() {
        return this.stringPlaceholdersTranslator;
    }

    public GUI setStringPlaceholdersTranslator(TriFunction<String, Language, Icon, String> stringPlaceholdersTranslator) {
        this.stringPlaceholdersTranslator = stringPlaceholdersTranslator;
        return this;
    }

    public GUI setServerStringPlaceholdersTranslator() {
        this.stringPlaceholdersTranslator = (t, u, v) -> PlaceholderManager.getInstance().translateServerPlaceholders((String)t, (Language)u, false);
        return this;
    }

    public TriFunction<List<String>, Language, Icon, List<String>> getStringListPlaceholdersTranslator() {
        return this.stringListPlaceholdersTranslator;
    }

    public GUI setStringListPlaceholdersTranslator(TriFunction<List<String>, Language, Icon, List<String>> stringListPlaceholdersTranslator) {
        this.stringListPlaceholdersTranslator = stringListPlaceholdersTranslator;
        return this;
    }

    protected abstract int load();
}

