/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import me.remigio07.chatplugin.api.common.storage.configuration.Configuration;
import me.remigio07.chatplugin.api.server.gui.GUILayout;
import me.remigio07.chatplugin.api.server.gui.Icon;
import me.remigio07.chatplugin.api.server.gui.IconLayout;
import me.remigio07.chatplugin.api.server.gui.OpenActions;
import me.remigio07.chatplugin.api.server.language.Language;
import me.remigio07.chatplugin.api.server.util.adapter.user.SoundAdapter;

public class FillableGUILayout
extends GUILayout {
    protected int startSlot = -1;
    protected int endSlot = -1;
    protected Icon emptyListIcon;
    protected List<IconLayout> iconsLayouts = new CopyOnWriteArrayList<IconLayout>();

    protected FillableGUILayout(String id, int rows, OpenActions openActions, SoundAdapter clickSound, Map<Language, String> titles) {
        super(id, rows, openActions, clickSound, titles);
    }

    protected FillableGUILayout(Configuration configuration) {
        super(configuration);
    }

    public int getStartSlot() {
        return this.startSlot;
    }

    public void setStartSlot(int startSlot) {
        if (startSlot < 0 || startSlot > this.getSize() - 1 || this.endSlot != -1 && startSlot > this.endSlot) {
            throw new IndexOutOfBoundsException("Specified start slot's position (" + startSlot + ") is outside of range 0 - " + (this.getSize() - 1) + " or bigger than end slot's position (" + this.endSlot + ")");
        }
        this.startSlot = startSlot;
    }

    public int getEndSlot() {
        return this.endSlot;
    }

    public void setEndSlot(int endSlot) {
        if (endSlot < 0 || endSlot > this.getSize() - 1 || this.startSlot != -1 && this.startSlot > endSlot) {
            throw new IndexOutOfBoundsException("Specified start slot's position (" + this.startSlot + ") is outside of range 0 - " + (this.getSize() - 1) + " or bigger than end slot's position (" + endSlot + ")");
        }
        this.endSlot = endSlot;
    }

    public Icon getEmptyListIcon() {
        return this.emptyListIcon;
    }

    public void setEmptyListIcon(Icon emptyListIcon) {
        this.emptyListIcon = emptyListIcon;
    }

    public List<IconLayout> getIconsLayouts() {
        return this.iconsLayouts;
    }

    public IconLayout getIconLayout(String id) {
        for (IconLayout iconLayout : this.iconsLayouts) {
            if (!iconLayout.getID().equals(id)) continue;
            return iconLayout;
        }
        return null;
    }

    public void setIconLayout(IconLayout iconLayout) {
        int size = this.iconsLayouts.size();
        if (size == 0) {
            this.iconsLayouts.add(iconLayout);
        } else {
            for (int i = 0; i < size; ++i) {
                if (this.iconsLayouts.get(i).getID().equals(iconLayout.getID())) {
                    this.iconsLayouts.set(i, iconLayout);
                    continue;
                }
                this.iconsLayouts.add(iconLayout);
            }
        }
    }

    public void removeIconLayout(String id) {
        for (IconLayout iconLayout : new ArrayList<IconLayout>(this.iconsLayouts)) {
            if (!iconLayout.getID().equals(id)) continue;
            this.iconsLayouts.remove(iconLayout);
        }
    }

    public static abstract class Builder
    extends GUILayout.Builder {
        public abstract Builder setSlots(int var1, int var2);

        public abstract Builder setEmptyListIcon(Icon var1);

        public abstract Builder setIconLayout(IconLayout var1);

        public abstract FillableGUILayout build();
    }
}

