/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.chat.channel.data;

import java.util.List;
import java.util.stream.Collectors;
import me.remigio07.chatplugin.api.server.chat.channel.ChatChannelType;
import me.remigio07.chatplugin.api.server.chat.channel.data.ChatChannelData;
import me.remigio07.chatplugin.api.server.language.Language;
import me.remigio07.chatplugin.api.server.player.ChatPluginServerPlayer;

public class LocalChatChannel
extends ChatChannelData {
    public static final String[] PLACEHOLDERS = new String[]{"channel_range"};
    private int range;

    public LocalChatChannel(int range) {
        this.range = range;
    }

    @Override
    public ChatChannelType getType() {
        return ChatChannelType.LOCAL;
    }

    @Override
    public List<ChatPluginServerPlayer> getRecipients(List<ChatPluginServerPlayer> players, ChatPluginServerPlayer sender, boolean excludeVanished) {
        return super.getRecipients(players, sender, excludeVanished).stream().filter(other -> sender.getWorld().equals(other.getWorld()) && sender.getDistance(other.getX(), other.getY(), other.getZ()) < (double)this.range).collect(Collectors.toList());
    }

    @Override
    public String formatPlaceholders(String input, Language language) {
        return input.replace("{channel_range}", String.valueOf(this.range));
    }

    public int getRange() {
        return this.range;
    }
}

