/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.chat.channel.data;

import me.remigio07.chatplugin.api.common.discord.DiscordBot;
import me.remigio07.chatplugin.api.server.chat.channel.ChatChannelType;
import me.remigio07.chatplugin.api.server.chat.channel.data.SocialChatChannel;
import me.remigio07.chatplugin.api.server.language.Language;

public class DiscordChatChannel
extends SocialChatChannel {
    public static final String[] PLACEHOLDERS = new String[]{"channel_discord_channel_id", "channel_discord_channel_name"};
    private String discordFormat;
    private long channelID;

    public DiscordChatChannel(String minecraftFormat, String discordFormat, long channelID) {
        super(minecraftFormat);
        this.discordFormat = discordFormat;
        this.channelID = channelID;
    }

    @Override
    public ChatChannelType getType() {
        return ChatChannelType.DISCORD;
    }

    @Override
    public String formatPlaceholders(String input, Language language) {
        return input.replace("{channel_discord_channel_id}", String.valueOf(this.channelID)).replace("{channel_discord_channel_name}", DiscordBot.getInstance().getChannelName(this.channelID));
    }

    public String getDiscordFormat() {
        return this.discordFormat;
    }

    public long getChannelID() {
        return this.channelID;
    }
}

