/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.chat.channel;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import me.remigio07.chatplugin.api.common.player.OfflinePlayer;
import me.remigio07.chatplugin.api.common.util.Utils;
import me.remigio07.chatplugin.api.common.util.text.ChatColor;
import me.remigio07.chatplugin.api.server.chat.channel.ChatChannelType;
import me.remigio07.chatplugin.api.server.chat.channel.data.ChatChannelData;
import me.remigio07.chatplugin.api.server.language.Language;
import me.remigio07.chatplugin.api.server.player.ChatPluginServerPlayer;

public class ChatChannel<T extends ChatChannelData> {
    public static final String[] PLACEHOLDERS = new String[]{"channel_id", "channel_display_name", "channel_prefix", "channel_type", "channel_aliases", "channel_languages", "channel_access", "channel_writing", "channel_listeners", "channel_listeners_amount"};
    protected String id;
    protected String displayName;
    protected String prefix;
    protected String format;
    protected boolean accessRestricted;
    protected boolean writingRestricted;
    protected boolean consoleIncluded;
    protected List<String> aliases;
    protected List<Language> languages;
    protected T data;
    protected List<ChatPluginServerPlayer> listeners = new CopyOnWriteArrayList<ChatPluginServerPlayer>();

    public ChatChannel(String id, String displayName, String prefix, String format, boolean accessRestricted, boolean writingRestricted, boolean consoleIncluded, List<String> aliases, List<Language> languages, T data) {
        this.id = id;
        this.displayName = displayName;
        this.prefix = prefix;
        this.format = format;
        this.accessRestricted = accessRestricted;
        this.writingRestricted = writingRestricted;
        this.consoleIncluded = consoleIncluded;
        this.aliases = aliases;
        this.languages = languages;
        this.data = data;
    }

    public String getID() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getFormat() {
        return this.format;
    }

    public boolean isAccessRestricted() {
        return this.accessRestricted;
    }

    public boolean isWritingRestricted() {
        return this.writingRestricted;
    }

    public boolean isConsoleIncluded() {
        return this.consoleIncluded;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public List<Language> getLanguages() {
        return this.languages;
    }

    public T getData() {
        return this.data;
    }

    public List<ChatPluginServerPlayer> getListeners() {
        return this.listeners;
    }

    public boolean canAccess(ChatPluginServerPlayer player) {
        return !this.accessRestricted || player.hasPermission("chatplugin.channels." + this.id);
    }

    public boolean canWrite(ChatPluginServerPlayer player) {
        return !this.writingRestricted || player.hasPermission("chatplugin.channels." + this.id + ".write");
    }

    public ChatChannelType getType() {
        return ((ChatChannelData)this.data).getType();
    }

    public List<ChatPluginServerPlayer> getRecipients(ChatPluginServerPlayer sender, boolean excludeVanished) {
        return ((ChatChannelData)this.data).getRecipients(this.listeners, sender, excludeVanished);
    }

    public String formatPlaceholders(String input, Language language) {
        return ((ChatChannelData)this.data).formatPlaceholders(input, language).replace("{channel_id}", this.id).replace("{channel_display_name}", this.displayName == null ? this.id : ChatColor.translate(this.displayName)).replace("{channel_prefix}", language.getMessage(this.prefix == null ? "placeholders.not-present" : this.prefix, new Object[0])).replace("{channel_type}", language.getMessage("chat.channel.types." + this.getType().name().toLowerCase(), new Object[0])).replace("{channel_aliases}", Utils.getStringFromList(this.aliases, false, true)).replace("{channel_languages}", Utils.getStringFromList(this.languages.stream().map(Language::getDisplayName).collect(Collectors.toList()), false, true)).replace("{channel_access}", language.getMessage("chat.channel.restrictions." + (this.accessRestricted ? "restricted" : "free"), new Object[0])).replace("{channel_writing}", language.getMessage("chat.channel.restrictions." + (this.accessRestricted ? "restricted" : "free"), new Object[0])).replace("{channel_listeners}", Utils.getStringFromList(this.listeners.stream().map(OfflinePlayer::getName).collect(Collectors.toList()), false, true)).replace("{channel_listeners_amount}", String.valueOf(this.listeners.size()));
    }

    public List<String> formatPlaceholders(List<String> input, Language language) {
        return input.stream().map(str -> this.formatPlaceholders((String)str, language)).collect(Collectors.toList());
    }
}

