/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.chat;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManager;
import me.remigio07.chatplugin.api.server.player.ChatPluginServerPlayer;
import me.remigio07.chatplugin.api.server.util.PlaceholderType;

public abstract class StaffChatManager
implements ChatPluginManager {
    protected static StaffChatManager instance;
    protected boolean enabled;
    protected String playerFormat;
    protected String consoleFormat;
    protected Set<PlaceholderType> placeholderTypes = Collections.emptySet();
    protected List<UUID> players = new CopyOnWriteArrayList<UUID>();
    protected long loadTime;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public String getPlayerFormat() {
        return this.playerFormat;
    }

    public String getConsoleFormat() {
        return this.consoleFormat;
    }

    public Set<PlaceholderType> getPlaceholderTypes() {
        return this.placeholderTypes;
    }

    public List<UUID> getPlayers() {
        return this.players;
    }

    public void addPlayer(UUID player) {
        if (!this.players.contains(player)) {
            this.players.add(player);
        }
    }

    public void removePlayer(UUID player) {
        this.players.remove(player);
    }

    public void clearPlayers() {
        this.players.clear();
    }

    public boolean isUsingStaffChat(UUID player) {
        return this.players.contains(player);
    }

    public static StaffChatManager getInstance() {
        return instance;
    }

    public abstract void sendPlayerMessage(ChatPluginServerPlayer var1, String var2);

    public abstract void sendConsoleMessage(String var1);
}

