/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.chat;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import me.remigio07.chatplugin.api.common.util.manager.ChatPluginManager;
import me.remigio07.chatplugin.api.common.util.text.ChatColor;
import me.remigio07.chatplugin.api.server.chat.channel.ChatChannel;
import me.remigio07.chatplugin.api.server.chat.channel.data.ChatChannelData;
import me.remigio07.chatplugin.api.server.player.ChatPluginServerPlayer;

public abstract class InstantEmojisManager
implements ChatPluginManager {
    protected static InstantEmojisManager instance;
    protected boolean enabled;
    protected List<InstantEmoji> instantEmojis = new ArrayList<InstantEmoji>();
    protected List<ChatColor> tones = new ArrayList<ChatColor>();
    protected long loadTime;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public List<InstantEmoji> getInstantEmojis() {
        return this.instantEmojis;
    }

    public InstantEmoji getInstantEmoji(String id) {
        return this.instantEmojis.stream().filter(instantEmoji -> instantEmoji.getID().equalsIgnoreCase(id)).findAny().orElse(null);
    }

    public List<ChatColor> getTones() {
        return this.tones;
    }

    public ChatColor getDefaultTone() {
        return this.tones.isEmpty() ? null : this.tones.get(0);
    }

    public static InstantEmojisManager getInstance() {
        return instance;
    }

    public abstract String translateInstantEmojis(ChatPluginServerPlayer var1, String var2, ChatChannel<? extends ChatChannelData> var3, List<InstantEmoji> var4);

    public abstract List<InstantEmoji> getInstantEmojis(ChatPluginServerPlayer var1, String var2);

    public static class InstantEmoji {
        private String id;
        private String string;
        private String literalPattern;

        public InstantEmoji(String id, String string) {
            if (string.contains(" ")) {
                throw new IllegalArgumentException("Instant emoji's string cannot contain spaces");
            }
            this.id = id;
            this.string = ChatColor.translate(string);
            this.literalPattern = Pattern.quote(id);
        }

        public String toString() {
            return new StringJoiner(", ", "InstantEmoji{", "}").add("id=\"" + this.id + "\"").add("string=\"" + this.string + "\"").toString();
        }

        public String getID() {
            return this.id;
        }

        public String getString() {
            return this.string;
        }

        public String getLiteralPattern() {
            return this.literalPattern;
        }
    }
}

