/*
 * Decompiled with CFR 0.152.
 */
package me.remigio07.chatplugin.api.server.ad;

import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import me.remigio07.chatplugin.api.common.util.adapter.text.ClickActionAdapter;
import me.remigio07.chatplugin.api.server.ad.AdManager;
import me.remigio07.chatplugin.api.server.language.Language;
import me.remigio07.chatplugin.api.server.rank.Rank;

public class Ad {
    private String id;
    private Map<Language, String> texts;
    private Map<Language, String> hovers;
    private Map<Language, String> clickValues;
    private ClickActionAdapter clickAction;
    private List<Rank> disabledRanks;

    public Ad(String id, Map<Language, String> texts, Map<Language, String> hovers, ClickActionAdapter clickAction, Map<Language, String> clickValues, List<Rank> disabledRanks) {
        if (!AdManager.getInstance().isValidAdID(id)) {
            throw new IllegalArgumentException("Ad ID \"" + id + "\" does not respect the following pattern: \"" + AdManager.AD_ID_PATTERN.pattern() + "\"");
        }
        if (texts.get(Language.getMainLanguage()) == null) {
            throw new NoSuchElementException("Specified map does not contain a translation for the main language");
        }
        this.id = id;
        this.texts = texts;
        this.hovers = hovers;
        this.clickAction = clickAction;
        this.clickValues = clickValues;
        this.disabledRanks = disabledRanks;
    }

    public String toString() {
        return "Ad{id=\"" + this.id + "\"}";
    }

    public String getID() {
        return this.id;
    }

    public Map<Language, String> getTexts() {
        return this.texts;
    }

    public String getText(Language language, boolean avoidNull) {
        return this.texts.get(language) == null ? (avoidNull ? this.texts.get(Language.getMainLanguage()) : null) : this.texts.get(language);
    }

    public Map<Language, String> getHovers() {
        return this.hovers;
    }

    public String getHover(Language language) {
        return this.hovers.get(language);
    }

    public ClickActionAdapter getClickAction() {
        return this.clickAction;
    }

    public Ad setClickAction(ClickActionAdapter clickAction) {
        this.clickAction = clickAction;
        return this;
    }

    public Map<Language, String> getClickValues() {
        return this.clickValues;
    }

    public String getClickValue(Language language) {
        return this.clickValues.get(language);
    }

    public List<Rank> getDisabledRanks() {
        return this.disabledRanks;
    }
}

